// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The schema type. </summary>
    public readonly partial struct IntegrationAccountSchemaType : IEquatable<IntegrationAccountSchemaType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountSchemaType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationAccountSchemaType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string XmlValue = "Xml";

        /// <summary> NotSpecified. </summary>
        public static IntegrationAccountSchemaType NotSpecified { get; } = new IntegrationAccountSchemaType(NotSpecifiedValue);
        /// <summary> Xml. </summary>
        public static IntegrationAccountSchemaType Xml { get; } = new IntegrationAccountSchemaType(XmlValue);
        /// <summary> Determines if two <see cref="IntegrationAccountSchemaType"/> values are the same. </summary>
        public static bool operator ==(IntegrationAccountSchemaType left, IntegrationAccountSchemaType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationAccountSchemaType"/> values are not the same. </summary>
        public static bool operator !=(IntegrationAccountSchemaType left, IntegrationAccountSchemaType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationAccountSchemaType"/>. </summary>
        public static implicit operator IntegrationAccountSchemaType(string value) => new IntegrationAccountSchemaType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationAccountSchemaType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationAccountSchemaType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
