// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The integration account partner content. </summary>
    public partial class IntegrationAccountPartnerContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountPartnerContent"/>. </summary>
        public IntegrationAccountPartnerContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountPartnerContent"/>. </summary>
        /// <param name="b2b"> The B2B partner content. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationAccountPartnerContent(B2BPartnerContent b2b, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            B2B = b2b;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The B2B partner content. </summary>
        internal B2BPartnerContent B2B { get; set; }
        /// <summary> The list of partner business identities. </summary>
        public IList<IntegrationAccountBusinessIdentity> B2BBusinessIdentities
        {
            get
            {
                if (B2B is null)
                    B2B = new B2BPartnerContent();
                return B2B.BusinessIdentities;
            }
        }
    }
}
