// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The map type. </summary>
    public readonly partial struct IntegrationAccountMapType : IEquatable<IntegrationAccountMapType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountMapType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public IntegrationAccountMapType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string XsltValue = "Xslt";
        private const string Xslt20Value = "Xslt20";
        private const string Xslt30Value = "Xslt30";
        private const string LiquidValue = "Liquid";

        /// <summary> NotSpecified. </summary>
        public static IntegrationAccountMapType NotSpecified { get; } = new IntegrationAccountMapType(NotSpecifiedValue);
        /// <summary> Xslt. </summary>
        public static IntegrationAccountMapType Xslt { get; } = new IntegrationAccountMapType(XsltValue);
        /// <summary> Xslt20. </summary>
        public static IntegrationAccountMapType Xslt20 { get; } = new IntegrationAccountMapType(Xslt20Value);
        /// <summary> Xslt30. </summary>
        public static IntegrationAccountMapType Xslt30 { get; } = new IntegrationAccountMapType(Xslt30Value);
        /// <summary> Liquid. </summary>
        public static IntegrationAccountMapType Liquid { get; } = new IntegrationAccountMapType(LiquidValue);
        /// <summary> Determines if two <see cref="IntegrationAccountMapType"/> values are the same. </summary>
        public static bool operator ==(IntegrationAccountMapType left, IntegrationAccountMapType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IntegrationAccountMapType"/> values are not the same. </summary>
        public static bool operator !=(IntegrationAccountMapType left, IntegrationAccountMapType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="IntegrationAccountMapType"/>. </summary>
        public static implicit operator IntegrationAccountMapType(string value) => new IntegrationAccountMapType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IntegrationAccountMapType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IntegrationAccountMapType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
