// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The reference to the key vault key. </summary>
    public partial class IntegrationAccountKeyVaultKeyReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKeyReference"/>. </summary>
        /// <param name="keyName"> The private key name in key vault. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="keyName"/> is null. </exception>
        public IntegrationAccountKeyVaultKeyReference(string keyName)
        {
            Argument.AssertNotNull(keyName, nameof(keyName));

            KeyName = keyName;
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKeyReference"/>. </summary>
        /// <param name="keyName"> The private key name in key vault. </param>
        /// <param name="keyVersion"> The private key version in key vault. </param>
        /// <param name="resourceId"> The resource id. </param>
        /// <param name="resourceName"> The resource name. </param>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationAccountKeyVaultKeyReference(string keyName, string keyVersion, ResourceIdentifier resourceId, string resourceName, ResourceType? resourceType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            KeyVersion = keyVersion;
            ResourceId = resourceId;
            ResourceName = resourceName;
            ResourceType = resourceType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKeyReference"/> for deserialization. </summary>
        internal IntegrationAccountKeyVaultKeyReference()
        {
        }

        /// <summary> The private key name in key vault. </summary>
        public string KeyName { get; set; }
        /// <summary> The private key version in key vault. </summary>
        public string KeyVersion { get; set; }
        /// <summary> The resource id. </summary>
        public ResourceIdentifier ResourceId { get; set; }
        /// <summary> The resource name. </summary>
        public string ResourceName { get; }
        /// <summary> The resource type. </summary>
        public ResourceType? ResourceType { get; }
    }
}
