// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> Collection of key vault keys. </summary>
    internal partial class IntegrationAccountKeyVaultKeyList
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKeyList"/>. </summary>
        internal IntegrationAccountKeyVaultKeyList()
        {
            Value = new ChangeTrackingList<IntegrationAccountKeyVaultKey>();
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKeyList"/>. </summary>
        /// <param name="value"> The key vault keys. </param>
        /// <param name="skipToken"> The skip token. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationAccountKeyVaultKeyList(IReadOnlyList<IntegrationAccountKeyVaultKey> value, string skipToken, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            SkipToken = skipToken;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The key vault keys. </summary>
        public IReadOnlyList<IntegrationAccountKeyVaultKey> Value { get; }
        /// <summary> The skip token. </summary>
        public string SkipToken { get; }
    }
}
