// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The key vault key. </summary>
    public partial class IntegrationAccountKeyVaultKey
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKey"/>. </summary>
        internal IntegrationAccountKeyVaultKey()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountKeyVaultKey"/>. </summary>
        /// <param name="keyId"> The key id. </param>
        /// <param name="isEnabled"> Whether the key is enabled or not. </param>
        /// <param name="createdOn"> When the key was created. </param>
        /// <param name="updatedOn"> When the key was updated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationAccountKeyVaultKey(Uri keyId, bool? isEnabled, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyId = keyId;
            IsEnabled = isEnabled;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The key id. </summary>
        public Uri KeyId { get; }
        /// <summary> Whether the key is enabled or not. </summary>
        public bool? IsEnabled { get; }
        /// <summary> When the key was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> When the key was updated. </summary>
        public DateTimeOffset? UpdatedOn { get; }
    }
}
