// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Logic.Models
{
    internal static partial class IntegrationAccountAgreementTypeExtensions
    {
        public static string ToSerialString(this IntegrationAccountAgreementType value) => value switch
        {
            IntegrationAccountAgreementType.NotSpecified => "NotSpecified",
            IntegrationAccountAgreementType.AS2 => "AS2",
            IntegrationAccountAgreementType.X12 => "X12",
            IntegrationAccountAgreementType.Edifact => "Edifact",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IntegrationAccountAgreementType value.")
        };

        public static IntegrationAccountAgreementType ToIntegrationAccountAgreementType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSpecified")) return IntegrationAccountAgreementType.NotSpecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "AS2")) return IntegrationAccountAgreementType.AS2;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "X12")) return IntegrationAccountAgreementType.X12;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Edifact")) return IntegrationAccountAgreementType.Edifact;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown IntegrationAccountAgreementType value.");
        }
    }
}
