// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class EdifactValidationSettings : IUtf8JsonSerializable, IJsonModel<EdifactValidationSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EdifactValidationSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EdifactValidationSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactValidationSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdifactValidationSettings)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("validateCharacterSet"u8);
            writer.WriteBooleanValue(ValidateCharacterSet);
            writer.WritePropertyName("checkDuplicateInterchangeControlNumber"u8);
            writer.WriteBooleanValue(CheckDuplicateInterchangeControlNumber);
            writer.WritePropertyName("interchangeControlNumberValidityDays"u8);
            writer.WriteNumberValue(InterchangeControlNumberValidityDays);
            writer.WritePropertyName("checkDuplicateGroupControlNumber"u8);
            writer.WriteBooleanValue(CheckDuplicateGroupControlNumber);
            writer.WritePropertyName("checkDuplicateTransactionSetControlNumber"u8);
            writer.WriteBooleanValue(CheckDuplicateTransactionSetControlNumber);
            writer.WritePropertyName("validateEDITypes"u8);
            writer.WriteBooleanValue(ValidateEdiTypes);
            writer.WritePropertyName("validateXSDTypes"u8);
            writer.WriteBooleanValue(ValidateXsdTypes);
            writer.WritePropertyName("allowLeadingAndTrailingSpacesAndZeroes"u8);
            writer.WriteBooleanValue(AllowLeadingAndTrailingSpacesAndZeroes);
            writer.WritePropertyName("trimLeadingAndTrailingSpacesAndZeroes"u8);
            writer.WriteBooleanValue(TrimLeadingAndTrailingSpacesAndZeroes);
            writer.WritePropertyName("trailingSeparatorPolicy"u8);
            writer.WriteStringValue(TrailingSeparatorPolicy.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EdifactValidationSettings IJsonModel<EdifactValidationSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactValidationSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdifactValidationSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEdifactValidationSettings(document.RootElement, options);
        }

        internal static EdifactValidationSettings DeserializeEdifactValidationSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool validateCharacterSet = default;
            bool checkDuplicateInterchangeControlNumber = default;
            int interchangeControlNumberValidityDays = default;
            bool checkDuplicateGroupControlNumber = default;
            bool checkDuplicateTransactionSetControlNumber = default;
            bool validateEdiTypes = default;
            bool validateXsdTypes = default;
            bool allowLeadingAndTrailingSpacesAndZeroes = default;
            bool trimLeadingAndTrailingSpacesAndZeroes = default;
            TrailingSeparatorPolicy trailingSeparatorPolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("validateCharacterSet"u8))
                {
                    validateCharacterSet = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("checkDuplicateInterchangeControlNumber"u8))
                {
                    checkDuplicateInterchangeControlNumber = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("interchangeControlNumberValidityDays"u8))
                {
                    interchangeControlNumberValidityDays = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("checkDuplicateGroupControlNumber"u8))
                {
                    checkDuplicateGroupControlNumber = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("checkDuplicateTransactionSetControlNumber"u8))
                {
                    checkDuplicateTransactionSetControlNumber = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("validateEDITypes"u8))
                {
                    validateEdiTypes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("validateXSDTypes"u8))
                {
                    validateXsdTypes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("allowLeadingAndTrailingSpacesAndZeroes"u8))
                {
                    allowLeadingAndTrailingSpacesAndZeroes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("trimLeadingAndTrailingSpacesAndZeroes"u8))
                {
                    trimLeadingAndTrailingSpacesAndZeroes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("trailingSeparatorPolicy"u8))
                {
                    trailingSeparatorPolicy = new TrailingSeparatorPolicy(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EdifactValidationSettings(
                validateCharacterSet,
                checkDuplicateInterchangeControlNumber,
                interchangeControlNumberValidityDays,
                checkDuplicateGroupControlNumber,
                checkDuplicateTransactionSetControlNumber,
                validateEdiTypes,
                validateXsdTypes,
                allowLeadingAndTrailingSpacesAndZeroes,
                trimLeadingAndTrailingSpacesAndZeroes,
                trailingSeparatorPolicy,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EdifactValidationSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactValidationSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EdifactValidationSettings)} does not support writing '{options.Format}' format.");
            }
        }

        EdifactValidationSettings IPersistableModel<EdifactValidationSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactValidationSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEdifactValidationSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EdifactValidationSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EdifactValidationSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
