// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class EdifactSchemaReference : IUtf8JsonSerializable, IJsonModel<EdifactSchemaReference>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EdifactSchemaReference>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EdifactSchemaReference>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactSchemaReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdifactSchemaReference)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("messageId"u8);
            writer.WriteStringValue(MessageId);
            writer.WritePropertyName("messageVersion"u8);
            writer.WriteStringValue(MessageVersion);
            writer.WritePropertyName("messageRelease"u8);
            writer.WriteStringValue(MessageRelease);
            if (Optional.IsDefined(SenderApplicationId))
            {
                writer.WritePropertyName("senderApplicationId"u8);
                writer.WriteStringValue(SenderApplicationId);
            }
            if (Optional.IsDefined(SenderApplicationQualifier))
            {
                writer.WritePropertyName("senderApplicationQualifier"u8);
                writer.WriteStringValue(SenderApplicationQualifier);
            }
            if (Optional.IsDefined(AssociationAssignedCode))
            {
                writer.WritePropertyName("associationAssignedCode"u8);
                writer.WriteStringValue(AssociationAssignedCode);
            }
            writer.WritePropertyName("schemaName"u8);
            writer.WriteStringValue(SchemaName);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EdifactSchemaReference IJsonModel<EdifactSchemaReference>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactSchemaReference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EdifactSchemaReference)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEdifactSchemaReference(document.RootElement, options);
        }

        internal static EdifactSchemaReference DeserializeEdifactSchemaReference(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string messageId = default;
            string messageVersion = default;
            string messageRelease = default;
            string senderApplicationId = default;
            string senderApplicationQualifier = default;
            string associationAssignedCode = default;
            string schemaName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("messageId"u8))
                {
                    messageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("messageVersion"u8))
                {
                    messageVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("messageRelease"u8))
                {
                    messageRelease = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("senderApplicationId"u8))
                {
                    senderApplicationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("senderApplicationQualifier"u8))
                {
                    senderApplicationQualifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("associationAssignedCode"u8))
                {
                    associationAssignedCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("schemaName"u8))
                {
                    schemaName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EdifactSchemaReference(
                messageId,
                messageVersion,
                messageRelease,
                senderApplicationId,
                senderApplicationQualifier,
                associationAssignedCode,
                schemaName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<EdifactSchemaReference>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactSchemaReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(EdifactSchemaReference)} does not support writing '{options.Format}' format.");
            }
        }

        EdifactSchemaReference IPersistableModel<EdifactSchemaReference>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EdifactSchemaReference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEdifactSchemaReference(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EdifactSchemaReference)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EdifactSchemaReference>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
