// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The Edifact agreement protocol settings. </summary>
    public partial class EdifactProtocolSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdifactProtocolSettings"/>. </summary>
        /// <param name="validationSettings"> The EDIFACT validation settings. </param>
        /// <param name="framingSettings"> The EDIFACT framing settings. </param>
        /// <param name="envelopeSettings"> The EDIFACT envelope settings. </param>
        /// <param name="acknowledgementSettings"> The EDIFACT acknowledgement settings. </param>
        /// <param name="messageFilter"> The EDIFACT message filter. </param>
        /// <param name="processingSettings"> The EDIFACT processing Settings. </param>
        /// <param name="schemaReferences"> The EDIFACT schema references. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="validationSettings"/>, <paramref name="framingSettings"/>, <paramref name="envelopeSettings"/>, <paramref name="acknowledgementSettings"/>, <paramref name="messageFilter"/>, <paramref name="processingSettings"/> or <paramref name="schemaReferences"/> is null. </exception>
        public EdifactProtocolSettings(EdifactValidationSettings validationSettings, EdifactFramingSettings framingSettings, EdifactEnvelopeSettings envelopeSettings, EdifactAcknowledgementSettings acknowledgementSettings, EdifactMessageFilter messageFilter, EdifactProcessingSettings processingSettings, IEnumerable<EdifactSchemaReference> schemaReferences)
        {
            Argument.AssertNotNull(validationSettings, nameof(validationSettings));
            Argument.AssertNotNull(framingSettings, nameof(framingSettings));
            Argument.AssertNotNull(envelopeSettings, nameof(envelopeSettings));
            Argument.AssertNotNull(acknowledgementSettings, nameof(acknowledgementSettings));
            Argument.AssertNotNull(messageFilter, nameof(messageFilter));
            Argument.AssertNotNull(processingSettings, nameof(processingSettings));
            Argument.AssertNotNull(schemaReferences, nameof(schemaReferences));

            ValidationSettings = validationSettings;
            FramingSettings = framingSettings;
            EnvelopeSettings = envelopeSettings;
            AcknowledgementSettings = acknowledgementSettings;
            MessageFilter = messageFilter;
            ProcessingSettings = processingSettings;
            EnvelopeOverrides = new ChangeTrackingList<EdifactEnvelopeOverride>();
            MessageFilterList = new ChangeTrackingList<EdifactMessageIdentifier>();
            SchemaReferences = schemaReferences.ToList();
            ValidationOverrides = new ChangeTrackingList<EdifactValidationOverride>();
            EdifactDelimiterOverrides = new ChangeTrackingList<EdifactDelimiterOverride>();
        }

        /// <summary> Initializes a new instance of <see cref="EdifactProtocolSettings"/>. </summary>
        /// <param name="validationSettings"> The EDIFACT validation settings. </param>
        /// <param name="framingSettings"> The EDIFACT framing settings. </param>
        /// <param name="envelopeSettings"> The EDIFACT envelope settings. </param>
        /// <param name="acknowledgementSettings"> The EDIFACT acknowledgement settings. </param>
        /// <param name="messageFilter"> The EDIFACT message filter. </param>
        /// <param name="processingSettings"> The EDIFACT processing Settings. </param>
        /// <param name="envelopeOverrides"> The EDIFACT envelope override settings. </param>
        /// <param name="messageFilterList"> The EDIFACT message filter list. </param>
        /// <param name="schemaReferences"> The EDIFACT schema references. </param>
        /// <param name="validationOverrides"> The EDIFACT validation override settings. </param>
        /// <param name="edifactDelimiterOverrides"> The EDIFACT delimiter override settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdifactProtocolSettings(EdifactValidationSettings validationSettings, EdifactFramingSettings framingSettings, EdifactEnvelopeSettings envelopeSettings, EdifactAcknowledgementSettings acknowledgementSettings, EdifactMessageFilter messageFilter, EdifactProcessingSettings processingSettings, IList<EdifactEnvelopeOverride> envelopeOverrides, IList<EdifactMessageIdentifier> messageFilterList, IList<EdifactSchemaReference> schemaReferences, IList<EdifactValidationOverride> validationOverrides, IList<EdifactDelimiterOverride> edifactDelimiterOverrides, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ValidationSettings = validationSettings;
            FramingSettings = framingSettings;
            EnvelopeSettings = envelopeSettings;
            AcknowledgementSettings = acknowledgementSettings;
            MessageFilter = messageFilter;
            ProcessingSettings = processingSettings;
            EnvelopeOverrides = envelopeOverrides;
            MessageFilterList = messageFilterList;
            SchemaReferences = schemaReferences;
            ValidationOverrides = validationOverrides;
            EdifactDelimiterOverrides = edifactDelimiterOverrides;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EdifactProtocolSettings"/> for deserialization. </summary>
        internal EdifactProtocolSettings()
        {
        }

        /// <summary> The EDIFACT validation settings. </summary>
        public EdifactValidationSettings ValidationSettings { get; set; }
        /// <summary> The EDIFACT framing settings. </summary>
        public EdifactFramingSettings FramingSettings { get; set; }
        /// <summary> The EDIFACT envelope settings. </summary>
        public EdifactEnvelopeSettings EnvelopeSettings { get; set; }
        /// <summary> The EDIFACT acknowledgement settings. </summary>
        public EdifactAcknowledgementSettings AcknowledgementSettings { get; set; }
        /// <summary> The EDIFACT message filter. </summary>
        internal EdifactMessageFilter MessageFilter { get; set; }
        /// <summary> The message filter type. </summary>
        public MessageFilterType? MessageFilterType
        {
            get => MessageFilter is null ? default(MessageFilterType?) : MessageFilter.MessageFilterType;
            set
            {
                MessageFilter = value.HasValue ? new EdifactMessageFilter(value.Value) : null;
            }
        }

        /// <summary> The EDIFACT processing Settings. </summary>
        public EdifactProcessingSettings ProcessingSettings { get; set; }
        /// <summary> The EDIFACT envelope override settings. </summary>
        public IList<EdifactEnvelopeOverride> EnvelopeOverrides { get; }
        /// <summary> The EDIFACT message filter list. </summary>
        public IList<EdifactMessageIdentifier> MessageFilterList { get; }
        /// <summary> The EDIFACT schema references. </summary>
        public IList<EdifactSchemaReference> SchemaReferences { get; }
        /// <summary> The EDIFACT validation override settings. </summary>
        public IList<EdifactValidationOverride> ValidationOverrides { get; }
        /// <summary> The EDIFACT delimiter override settings. </summary>
        public IList<EdifactDelimiterOverride> EdifactDelimiterOverrides { get; }
    }
}
