// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The Edifact agreement envelope settings. </summary>
    public partial class EdifactEnvelopeSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdifactEnvelopeSettings"/>. </summary>
        /// <param name="applyDelimiterStringAdvice"> The value indicating whether to apply delimiter string advice. </param>
        /// <param name="createGroupingSegments"> The value indicating whether to create grouping segments. </param>
        /// <param name="enableDefaultGroupHeaders"> The value indicating whether to enable default group headers. </param>
        /// <param name="interchangeControlNumberLowerBound"> The interchange control number lower bound. </param>
        /// <param name="interchangeControlNumberUpperBound"> The interchange control number upper bound. </param>
        /// <param name="rolloverInterchangeControlNumber"> The value indicating whether to rollover interchange control number. </param>
        /// <param name="groupControlNumberLowerBound"> The group control number lower bound. </param>
        /// <param name="groupControlNumberUpperBound"> The group control number upper bound. </param>
        /// <param name="rolloverGroupControlNumber"> The value indicating whether to rollover group control number. </param>
        /// <param name="overwriteExistingTransactionSetControlNumber"> The value indicating whether to overwrite existing transaction set control number. </param>
        /// <param name="transactionSetControlNumberLowerBound"> The transaction set control number lower bound. </param>
        /// <param name="transactionSetControlNumberUpperBound"> The transaction set control number upper bound. </param>
        /// <param name="rolloverTransactionSetControlNumber"> The value indicating whether to rollover transaction set control number. </param>
        /// <param name="isTestInterchange"> The value indicating whether the message is a test interchange. </param>
        public EdifactEnvelopeSettings(bool applyDelimiterStringAdvice, bool createGroupingSegments, bool enableDefaultGroupHeaders, long interchangeControlNumberLowerBound, long interchangeControlNumberUpperBound, bool rolloverInterchangeControlNumber, long groupControlNumberLowerBound, long groupControlNumberUpperBound, bool rolloverGroupControlNumber, bool overwriteExistingTransactionSetControlNumber, long transactionSetControlNumberLowerBound, long transactionSetControlNumberUpperBound, bool rolloverTransactionSetControlNumber, bool isTestInterchange)
        {
            ApplyDelimiterStringAdvice = applyDelimiterStringAdvice;
            CreateGroupingSegments = createGroupingSegments;
            EnableDefaultGroupHeaders = enableDefaultGroupHeaders;
            InterchangeControlNumberLowerBound = interchangeControlNumberLowerBound;
            InterchangeControlNumberUpperBound = interchangeControlNumberUpperBound;
            RolloverInterchangeControlNumber = rolloverInterchangeControlNumber;
            GroupControlNumberLowerBound = groupControlNumberLowerBound;
            GroupControlNumberUpperBound = groupControlNumberUpperBound;
            RolloverGroupControlNumber = rolloverGroupControlNumber;
            OverwriteExistingTransactionSetControlNumber = overwriteExistingTransactionSetControlNumber;
            TransactionSetControlNumberLowerBound = transactionSetControlNumberLowerBound;
            TransactionSetControlNumberUpperBound = transactionSetControlNumberUpperBound;
            RolloverTransactionSetControlNumber = rolloverTransactionSetControlNumber;
            IsTestInterchange = isTestInterchange;
        }

        /// <summary> Initializes a new instance of <see cref="EdifactEnvelopeSettings"/>. </summary>
        /// <param name="groupAssociationAssignedCode"> The group association assigned code. </param>
        /// <param name="communicationAgreementId"> The communication agreement id. </param>
        /// <param name="applyDelimiterStringAdvice"> The value indicating whether to apply delimiter string advice. </param>
        /// <param name="createGroupingSegments"> The value indicating whether to create grouping segments. </param>
        /// <param name="enableDefaultGroupHeaders"> The value indicating whether to enable default group headers. </param>
        /// <param name="recipientReferencePasswordValue"> The recipient reference password value. </param>
        /// <param name="recipientReferencePasswordQualifier"> The recipient reference password qualifier. </param>
        /// <param name="applicationReferenceId"> The application reference id. </param>
        /// <param name="processingPriorityCode"> The processing priority code. </param>
        /// <param name="interchangeControlNumberLowerBound"> The interchange control number lower bound. </param>
        /// <param name="interchangeControlNumberUpperBound"> The interchange control number upper bound. </param>
        /// <param name="rolloverInterchangeControlNumber"> The value indicating whether to rollover interchange control number. </param>
        /// <param name="interchangeControlNumberPrefix"> The interchange control number prefix. </param>
        /// <param name="interchangeControlNumberSuffix"> The interchange control number suffix. </param>
        /// <param name="senderReverseRoutingAddress"> The sender reverse routing address. </param>
        /// <param name="receiverReverseRoutingAddress"> The receiver reverse routing address. </param>
        /// <param name="functionalGroupId"> The functional group id. </param>
        /// <param name="groupControllingAgencyCode"> The group controlling agency code. </param>
        /// <param name="groupMessageVersion"> The group message version. </param>
        /// <param name="groupMessageRelease"> The group message release. </param>
        /// <param name="groupControlNumberLowerBound"> The group control number lower bound. </param>
        /// <param name="groupControlNumberUpperBound"> The group control number upper bound. </param>
        /// <param name="rolloverGroupControlNumber"> The value indicating whether to rollover group control number. </param>
        /// <param name="groupControlNumberPrefix"> The group control number prefix. </param>
        /// <param name="groupControlNumberSuffix"> The group control number suffix. </param>
        /// <param name="groupApplicationReceiverQualifier"> The group application receiver qualifier. </param>
        /// <param name="groupApplicationReceiverId"> The group application receiver id. </param>
        /// <param name="groupApplicationSenderQualifier"> The group application sender qualifier. </param>
        /// <param name="groupApplicationSenderId"> The group application sender id. </param>
        /// <param name="groupApplicationPassword"> The group application password. </param>
        /// <param name="overwriteExistingTransactionSetControlNumber"> The value indicating whether to overwrite existing transaction set control number. </param>
        /// <param name="transactionSetControlNumberPrefix"> The transaction set control number prefix. </param>
        /// <param name="transactionSetControlNumberSuffix"> The transaction set control number suffix. </param>
        /// <param name="transactionSetControlNumberLowerBound"> The transaction set control number lower bound. </param>
        /// <param name="transactionSetControlNumberUpperBound"> The transaction set control number upper bound. </param>
        /// <param name="rolloverTransactionSetControlNumber"> The value indicating whether to rollover transaction set control number. </param>
        /// <param name="isTestInterchange"> The value indicating whether the message is a test interchange. </param>
        /// <param name="senderInternalIdentification"> The sender internal identification. </param>
        /// <param name="senderInternalSubIdentification"> The sender internal sub identification. </param>
        /// <param name="receiverInternalIdentification"> The receiver internal identification. </param>
        /// <param name="receiverInternalSubIdentification"> The receiver internal sub identification. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdifactEnvelopeSettings(string groupAssociationAssignedCode, string communicationAgreementId, bool applyDelimiterStringAdvice, bool createGroupingSegments, bool enableDefaultGroupHeaders, string recipientReferencePasswordValue, string recipientReferencePasswordQualifier, string applicationReferenceId, string processingPriorityCode, long interchangeControlNumberLowerBound, long interchangeControlNumberUpperBound, bool rolloverInterchangeControlNumber, string interchangeControlNumberPrefix, string interchangeControlNumberSuffix, string senderReverseRoutingAddress, string receiverReverseRoutingAddress, string functionalGroupId, string groupControllingAgencyCode, string groupMessageVersion, string groupMessageRelease, long groupControlNumberLowerBound, long groupControlNumberUpperBound, bool rolloverGroupControlNumber, string groupControlNumberPrefix, string groupControlNumberSuffix, string groupApplicationReceiverQualifier, string groupApplicationReceiverId, string groupApplicationSenderQualifier, string groupApplicationSenderId, string groupApplicationPassword, bool overwriteExistingTransactionSetControlNumber, string transactionSetControlNumberPrefix, string transactionSetControlNumberSuffix, long transactionSetControlNumberLowerBound, long transactionSetControlNumberUpperBound, bool rolloverTransactionSetControlNumber, bool isTestInterchange, string senderInternalIdentification, string senderInternalSubIdentification, string receiverInternalIdentification, string receiverInternalSubIdentification, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupAssociationAssignedCode = groupAssociationAssignedCode;
            CommunicationAgreementId = communicationAgreementId;
            ApplyDelimiterStringAdvice = applyDelimiterStringAdvice;
            CreateGroupingSegments = createGroupingSegments;
            EnableDefaultGroupHeaders = enableDefaultGroupHeaders;
            RecipientReferencePasswordValue = recipientReferencePasswordValue;
            RecipientReferencePasswordQualifier = recipientReferencePasswordQualifier;
            ApplicationReferenceId = applicationReferenceId;
            ProcessingPriorityCode = processingPriorityCode;
            InterchangeControlNumberLowerBound = interchangeControlNumberLowerBound;
            InterchangeControlNumberUpperBound = interchangeControlNumberUpperBound;
            RolloverInterchangeControlNumber = rolloverInterchangeControlNumber;
            InterchangeControlNumberPrefix = interchangeControlNumberPrefix;
            InterchangeControlNumberSuffix = interchangeControlNumberSuffix;
            SenderReverseRoutingAddress = senderReverseRoutingAddress;
            ReceiverReverseRoutingAddress = receiverReverseRoutingAddress;
            FunctionalGroupId = functionalGroupId;
            GroupControllingAgencyCode = groupControllingAgencyCode;
            GroupMessageVersion = groupMessageVersion;
            GroupMessageRelease = groupMessageRelease;
            GroupControlNumberLowerBound = groupControlNumberLowerBound;
            GroupControlNumberUpperBound = groupControlNumberUpperBound;
            RolloverGroupControlNumber = rolloverGroupControlNumber;
            GroupControlNumberPrefix = groupControlNumberPrefix;
            GroupControlNumberSuffix = groupControlNumberSuffix;
            GroupApplicationReceiverQualifier = groupApplicationReceiverQualifier;
            GroupApplicationReceiverId = groupApplicationReceiverId;
            GroupApplicationSenderQualifier = groupApplicationSenderQualifier;
            GroupApplicationSenderId = groupApplicationSenderId;
            GroupApplicationPassword = groupApplicationPassword;
            OverwriteExistingTransactionSetControlNumber = overwriteExistingTransactionSetControlNumber;
            TransactionSetControlNumberPrefix = transactionSetControlNumberPrefix;
            TransactionSetControlNumberSuffix = transactionSetControlNumberSuffix;
            TransactionSetControlNumberLowerBound = transactionSetControlNumberLowerBound;
            TransactionSetControlNumberUpperBound = transactionSetControlNumberUpperBound;
            RolloverTransactionSetControlNumber = rolloverTransactionSetControlNumber;
            IsTestInterchange = isTestInterchange;
            SenderInternalIdentification = senderInternalIdentification;
            SenderInternalSubIdentification = senderInternalSubIdentification;
            ReceiverInternalIdentification = receiverInternalIdentification;
            ReceiverInternalSubIdentification = receiverInternalSubIdentification;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EdifactEnvelopeSettings"/> for deserialization. </summary>
        internal EdifactEnvelopeSettings()
        {
        }

        /// <summary> The group association assigned code. </summary>
        public string GroupAssociationAssignedCode { get; set; }
        /// <summary> The communication agreement id. </summary>
        public string CommunicationAgreementId { get; set; }
        /// <summary> The value indicating whether to apply delimiter string advice. </summary>
        public bool ApplyDelimiterStringAdvice { get; set; }
        /// <summary> The value indicating whether to create grouping segments. </summary>
        public bool CreateGroupingSegments { get; set; }
        /// <summary> The value indicating whether to enable default group headers. </summary>
        public bool EnableDefaultGroupHeaders { get; set; }
        /// <summary> The recipient reference password value. </summary>
        public string RecipientReferencePasswordValue { get; set; }
        /// <summary> The recipient reference password qualifier. </summary>
        public string RecipientReferencePasswordQualifier { get; set; }
        /// <summary> The application reference id. </summary>
        public string ApplicationReferenceId { get; set; }
        /// <summary> The processing priority code. </summary>
        public string ProcessingPriorityCode { get; set; }
        /// <summary> The interchange control number lower bound. </summary>
        public long InterchangeControlNumberLowerBound { get; set; }
        /// <summary> The interchange control number upper bound. </summary>
        public long InterchangeControlNumberUpperBound { get; set; }
        /// <summary> The value indicating whether to rollover interchange control number. </summary>
        public bool RolloverInterchangeControlNumber { get; set; }
        /// <summary> The interchange control number prefix. </summary>
        public string InterchangeControlNumberPrefix { get; set; }
        /// <summary> The interchange control number suffix. </summary>
        public string InterchangeControlNumberSuffix { get; set; }
        /// <summary> The sender reverse routing address. </summary>
        public string SenderReverseRoutingAddress { get; set; }
        /// <summary> The receiver reverse routing address. </summary>
        public string ReceiverReverseRoutingAddress { get; set; }
        /// <summary> The functional group id. </summary>
        public string FunctionalGroupId { get; set; }
        /// <summary> The group controlling agency code. </summary>
        public string GroupControllingAgencyCode { get; set; }
        /// <summary> The group message version. </summary>
        public string GroupMessageVersion { get; set; }
        /// <summary> The group message release. </summary>
        public string GroupMessageRelease { get; set; }
        /// <summary> The group control number lower bound. </summary>
        public long GroupControlNumberLowerBound { get; set; }
        /// <summary> The group control number upper bound. </summary>
        public long GroupControlNumberUpperBound { get; set; }
        /// <summary> The value indicating whether to rollover group control number. </summary>
        public bool RolloverGroupControlNumber { get; set; }
        /// <summary> The group control number prefix. </summary>
        public string GroupControlNumberPrefix { get; set; }
        /// <summary> The group control number suffix. </summary>
        public string GroupControlNumberSuffix { get; set; }
        /// <summary> The group application receiver qualifier. </summary>
        public string GroupApplicationReceiverQualifier { get; set; }
        /// <summary> The group application receiver id. </summary>
        public string GroupApplicationReceiverId { get; set; }
        /// <summary> The group application sender qualifier. </summary>
        public string GroupApplicationSenderQualifier { get; set; }
        /// <summary> The group application sender id. </summary>
        public string GroupApplicationSenderId { get; set; }
        /// <summary> The group application password. </summary>
        public string GroupApplicationPassword { get; set; }
        /// <summary> The value indicating whether to overwrite existing transaction set control number. </summary>
        public bool OverwriteExistingTransactionSetControlNumber { get; set; }
        /// <summary> The transaction set control number prefix. </summary>
        public string TransactionSetControlNumberPrefix { get; set; }
        /// <summary> The transaction set control number suffix. </summary>
        public string TransactionSetControlNumberSuffix { get; set; }
        /// <summary> The transaction set control number lower bound. </summary>
        public long TransactionSetControlNumberLowerBound { get; set; }
        /// <summary> The transaction set control number upper bound. </summary>
        public long TransactionSetControlNumberUpperBound { get; set; }
        /// <summary> The value indicating whether to rollover transaction set control number. </summary>
        public bool RolloverTransactionSetControlNumber { get; set; }
        /// <summary> The value indicating whether the message is a test interchange. </summary>
        public bool IsTestInterchange { get; set; }
        /// <summary> The sender internal identification. </summary>
        public string SenderInternalIdentification { get; set; }
        /// <summary> The sender internal sub identification. </summary>
        public string SenderInternalSubIdentification { get; set; }
        /// <summary> The receiver internal identification. </summary>
        public string ReceiverInternalIdentification { get; set; }
        /// <summary> The receiver internal sub identification. </summary>
        public string ReceiverInternalSubIdentification { get; set; }
    }
}
