// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The Edifact envelope override settings. </summary>
    public partial class EdifactEnvelopeOverride
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdifactEnvelopeOverride"/>. </summary>
        public EdifactEnvelopeOverride()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EdifactEnvelopeOverride"/>. </summary>
        /// <param name="messageId"> The message id on which this envelope settings has to be applied. </param>
        /// <param name="messageVersion"> The message version on which this envelope settings has to be applied. </param>
        /// <param name="messageRelease"> The message release version on which this envelope settings has to be applied. </param>
        /// <param name="messageAssociationAssignedCode"> The message association assigned code. </param>
        /// <param name="targetNamespace"> The target namespace on which this envelope settings has to be applied. </param>
        /// <param name="functionalGroupId"> The functional group id. </param>
        /// <param name="senderApplicationQualifier"> The sender application qualifier. </param>
        /// <param name="senderApplicationId"> The sender application id. </param>
        /// <param name="receiverApplicationQualifier"> The receiver application qualifier. </param>
        /// <param name="receiverApplicationId"> The receiver application id. </param>
        /// <param name="controllingAgencyCode"> The controlling agency code. </param>
        /// <param name="groupHeaderMessageVersion"> The group header message version. </param>
        /// <param name="groupHeaderMessageRelease"> The group header message release. </param>
        /// <param name="associationAssignedCode"> The association assigned code. </param>
        /// <param name="applicationPassword"> The application password. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdifactEnvelopeOverride(string messageId, string messageVersion, string messageRelease, string messageAssociationAssignedCode, string targetNamespace, string functionalGroupId, string senderApplicationQualifier, string senderApplicationId, string receiverApplicationQualifier, string receiverApplicationId, string controllingAgencyCode, string groupHeaderMessageVersion, string groupHeaderMessageRelease, string associationAssignedCode, string applicationPassword, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MessageId = messageId;
            MessageVersion = messageVersion;
            MessageRelease = messageRelease;
            MessageAssociationAssignedCode = messageAssociationAssignedCode;
            TargetNamespace = targetNamespace;
            FunctionalGroupId = functionalGroupId;
            SenderApplicationQualifier = senderApplicationQualifier;
            SenderApplicationId = senderApplicationId;
            ReceiverApplicationQualifier = receiverApplicationQualifier;
            ReceiverApplicationId = receiverApplicationId;
            ControllingAgencyCode = controllingAgencyCode;
            GroupHeaderMessageVersion = groupHeaderMessageVersion;
            GroupHeaderMessageRelease = groupHeaderMessageRelease;
            AssociationAssignedCode = associationAssignedCode;
            ApplicationPassword = applicationPassword;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The message id on which this envelope settings has to be applied. </summary>
        public string MessageId { get; set; }
        /// <summary> The message version on which this envelope settings has to be applied. </summary>
        public string MessageVersion { get; set; }
        /// <summary> The message release version on which this envelope settings has to be applied. </summary>
        public string MessageRelease { get; set; }
        /// <summary> The message association assigned code. </summary>
        public string MessageAssociationAssignedCode { get; set; }
        /// <summary> The target namespace on which this envelope settings has to be applied. </summary>
        public string TargetNamespace { get; set; }
        /// <summary> The functional group id. </summary>
        public string FunctionalGroupId { get; set; }
        /// <summary> The sender application qualifier. </summary>
        public string SenderApplicationQualifier { get; set; }
        /// <summary> The sender application id. </summary>
        public string SenderApplicationId { get; set; }
        /// <summary> The receiver application qualifier. </summary>
        public string ReceiverApplicationQualifier { get; set; }
        /// <summary> The receiver application id. </summary>
        public string ReceiverApplicationId { get; set; }
        /// <summary> The controlling agency code. </summary>
        public string ControllingAgencyCode { get; set; }
        /// <summary> The group header message version. </summary>
        public string GroupHeaderMessageVersion { get; set; }
        /// <summary> The group header message release. </summary>
        public string GroupHeaderMessageRelease { get; set; }
        /// <summary> The association assigned code. </summary>
        public string AssociationAssignedCode { get; set; }
        /// <summary> The application password. </summary>
        public string ApplicationPassword { get; set; }
    }
}
