// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The Edifact delimiter override settings. </summary>
    public partial class EdifactDelimiterOverride
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EdifactDelimiterOverride"/>. </summary>
        /// <param name="dataElementSeparator"> The data element separator. </param>
        /// <param name="componentSeparator"> The component separator. </param>
        /// <param name="segmentTerminator"> The segment terminator. </param>
        /// <param name="repetitionSeparator"> The repetition separator. </param>
        /// <param name="segmentTerminatorSuffix"> The segment terminator suffix. </param>
        /// <param name="decimalPointIndicator"> The decimal point indicator. </param>
        /// <param name="releaseIndicator"> The release indicator. </param>
        public EdifactDelimiterOverride(int dataElementSeparator, int componentSeparator, int segmentTerminator, int repetitionSeparator, SegmentTerminatorSuffix segmentTerminatorSuffix, EdifactDecimalIndicator decimalPointIndicator, int releaseIndicator)
        {
            DataElementSeparator = dataElementSeparator;
            ComponentSeparator = componentSeparator;
            SegmentTerminator = segmentTerminator;
            RepetitionSeparator = repetitionSeparator;
            SegmentTerminatorSuffix = segmentTerminatorSuffix;
            DecimalPointIndicator = decimalPointIndicator;
            ReleaseIndicator = releaseIndicator;
        }

        /// <summary> Initializes a new instance of <see cref="EdifactDelimiterOverride"/>. </summary>
        /// <param name="messageId"> The message id. </param>
        /// <param name="messageVersion"> The message version. </param>
        /// <param name="messageRelease"> The message release. </param>
        /// <param name="dataElementSeparator"> The data element separator. </param>
        /// <param name="componentSeparator"> The component separator. </param>
        /// <param name="segmentTerminator"> The segment terminator. </param>
        /// <param name="repetitionSeparator"> The repetition separator. </param>
        /// <param name="segmentTerminatorSuffix"> The segment terminator suffix. </param>
        /// <param name="decimalPointIndicator"> The decimal point indicator. </param>
        /// <param name="releaseIndicator"> The release indicator. </param>
        /// <param name="messageAssociationAssignedCode"> The message association assigned code. </param>
        /// <param name="targetNamespace"> The target namespace on which this delimiter settings has to be applied. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EdifactDelimiterOverride(string messageId, string messageVersion, string messageRelease, int dataElementSeparator, int componentSeparator, int segmentTerminator, int repetitionSeparator, SegmentTerminatorSuffix segmentTerminatorSuffix, EdifactDecimalIndicator decimalPointIndicator, int releaseIndicator, string messageAssociationAssignedCode, string targetNamespace, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MessageId = messageId;
            MessageVersion = messageVersion;
            MessageRelease = messageRelease;
            DataElementSeparator = dataElementSeparator;
            ComponentSeparator = componentSeparator;
            SegmentTerminator = segmentTerminator;
            RepetitionSeparator = repetitionSeparator;
            SegmentTerminatorSuffix = segmentTerminatorSuffix;
            DecimalPointIndicator = decimalPointIndicator;
            ReleaseIndicator = releaseIndicator;
            MessageAssociationAssignedCode = messageAssociationAssignedCode;
            TargetNamespace = targetNamespace;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="EdifactDelimiterOverride"/> for deserialization. </summary>
        internal EdifactDelimiterOverride()
        {
        }

        /// <summary> The message id. </summary>
        public string MessageId { get; set; }
        /// <summary> The message version. </summary>
        public string MessageVersion { get; set; }
        /// <summary> The message release. </summary>
        public string MessageRelease { get; set; }
        /// <summary> The data element separator. </summary>
        public int DataElementSeparator { get; set; }
        /// <summary> The component separator. </summary>
        public int ComponentSeparator { get; set; }
        /// <summary> The segment terminator. </summary>
        public int SegmentTerminator { get; set; }
        /// <summary> The repetition separator. </summary>
        public int RepetitionSeparator { get; set; }
        /// <summary> The segment terminator suffix. </summary>
        public SegmentTerminatorSuffix SegmentTerminatorSuffix { get; set; }
        /// <summary> The decimal point indicator. </summary>
        public EdifactDecimalIndicator DecimalPointIndicator { get; set; }
        /// <summary> The release indicator. </summary>
        public int ReleaseIndicator { get; set; }
        /// <summary> The message association assigned code. </summary>
        public string MessageAssociationAssignedCode { get; set; }
        /// <summary> The target namespace on which this delimiter settings has to be applied. </summary>
        public string TargetNamespace { get; set; }
    }
}
