// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Logic.Models
{
    internal static partial class EdifactDecimalIndicatorExtensions
    {
        public static string ToSerialString(this EdifactDecimalIndicator value) => value switch
        {
            EdifactDecimalIndicator.NotSpecified => "NotSpecified",
            EdifactDecimalIndicator.Comma => "Comma",
            EdifactDecimalIndicator.Decimal => "Decimal",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EdifactDecimalIndicator value.")
        };

        public static EdifactDecimalIndicator ToEdifactDecimalIndicator(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotSpecified")) return EdifactDecimalIndicator.NotSpecified;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Comma")) return EdifactDecimalIndicator.Comma;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Decimal")) return EdifactDecimalIndicator.Decimal;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown EdifactDecimalIndicator value.");
        }
    }
}
