// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The artifact content properties definition. </summary>
    public partial class ArtifactContentProperties : ArtifactProperties
    {
        /// <summary> Initializes a new instance of <see cref="ArtifactContentProperties"/>. </summary>
        public ArtifactContentProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ArtifactContentProperties"/>. </summary>
        /// <param name="createdOn"> The artifact creation time. </param>
        /// <param name="changedOn"> The artifact changed time. </param>
        /// <param name="metadata"> Anything. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="content"> Anything. </param>
        /// <param name="contentType"> The content type. </param>
        /// <param name="contentLink"> The content link. </param>
        internal ArtifactContentProperties(DateTimeOffset? createdOn, DateTimeOffset? changedOn, BinaryData metadata, IDictionary<string, BinaryData> serializedAdditionalRawData, BinaryData content, ContentType? contentType, LogicContentLink contentLink) : base(createdOn, changedOn, metadata, serializedAdditionalRawData)
        {
            Content = content;
            ContentType = contentType;
            ContentLink = contentLink;
        }

        /// <summary>
        /// Anything
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Content { get; set; }
        /// <summary> The content type. </summary>
        public ContentType? ContentType { get; set; }
        /// <summary> The content link. </summary>
        public LogicContentLink ContentLink { get; set; }
    }
}
