// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The AS2 agreement protocol settings. </summary>
    public partial class AS2ProtocolSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AS2ProtocolSettings"/>. </summary>
        /// <param name="messageConnectionSettings"> The message connection settings. </param>
        /// <param name="acknowledgementConnectionSettings"> The acknowledgement connection settings. </param>
        /// <param name="mdnSettings"> The MDN settings. </param>
        /// <param name="securitySettings"> The security settings. </param>
        /// <param name="validationSettings"> The validation settings. </param>
        /// <param name="envelopeSettings"> The envelope settings. </param>
        /// <param name="errorSettings"> The error settings. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="messageConnectionSettings"/>, <paramref name="acknowledgementConnectionSettings"/>, <paramref name="mdnSettings"/>, <paramref name="securitySettings"/>, <paramref name="validationSettings"/>, <paramref name="envelopeSettings"/> or <paramref name="errorSettings"/> is null. </exception>
        public AS2ProtocolSettings(AS2MessageConnectionSettings messageConnectionSettings, AS2AcknowledgementConnectionSettings acknowledgementConnectionSettings, AS2MdnSettings mdnSettings, AS2SecuritySettings securitySettings, AS2ValidationSettings validationSettings, AS2EnvelopeSettings envelopeSettings, AS2ErrorSettings errorSettings)
        {
            Argument.AssertNotNull(messageConnectionSettings, nameof(messageConnectionSettings));
            Argument.AssertNotNull(acknowledgementConnectionSettings, nameof(acknowledgementConnectionSettings));
            Argument.AssertNotNull(mdnSettings, nameof(mdnSettings));
            Argument.AssertNotNull(securitySettings, nameof(securitySettings));
            Argument.AssertNotNull(validationSettings, nameof(validationSettings));
            Argument.AssertNotNull(envelopeSettings, nameof(envelopeSettings));
            Argument.AssertNotNull(errorSettings, nameof(errorSettings));

            MessageConnectionSettings = messageConnectionSettings;
            AcknowledgementConnectionSettings = acknowledgementConnectionSettings;
            MdnSettings = mdnSettings;
            SecuritySettings = securitySettings;
            ValidationSettings = validationSettings;
            EnvelopeSettings = envelopeSettings;
            ErrorSettings = errorSettings;
        }

        /// <summary> Initializes a new instance of <see cref="AS2ProtocolSettings"/>. </summary>
        /// <param name="messageConnectionSettings"> The message connection settings. </param>
        /// <param name="acknowledgementConnectionSettings"> The acknowledgement connection settings. </param>
        /// <param name="mdnSettings"> The MDN settings. </param>
        /// <param name="securitySettings"> The security settings. </param>
        /// <param name="validationSettings"> The validation settings. </param>
        /// <param name="envelopeSettings"> The envelope settings. </param>
        /// <param name="errorSettings"> The error settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AS2ProtocolSettings(AS2MessageConnectionSettings messageConnectionSettings, AS2AcknowledgementConnectionSettings acknowledgementConnectionSettings, AS2MdnSettings mdnSettings, AS2SecuritySettings securitySettings, AS2ValidationSettings validationSettings, AS2EnvelopeSettings envelopeSettings, AS2ErrorSettings errorSettings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MessageConnectionSettings = messageConnectionSettings;
            AcknowledgementConnectionSettings = acknowledgementConnectionSettings;
            MdnSettings = mdnSettings;
            SecuritySettings = securitySettings;
            ValidationSettings = validationSettings;
            EnvelopeSettings = envelopeSettings;
            ErrorSettings = errorSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AS2ProtocolSettings"/> for deserialization. </summary>
        internal AS2ProtocolSettings()
        {
        }

        /// <summary> The message connection settings. </summary>
        public AS2MessageConnectionSettings MessageConnectionSettings { get; set; }
        /// <summary> The acknowledgement connection settings. </summary>
        public AS2AcknowledgementConnectionSettings AcknowledgementConnectionSettings { get; set; }
        /// <summary> The MDN settings. </summary>
        public AS2MdnSettings MdnSettings { get; set; }
        /// <summary> The security settings. </summary>
        public AS2SecuritySettings SecuritySettings { get; set; }
        /// <summary> The validation settings. </summary>
        public AS2ValidationSettings ValidationSettings { get; set; }
        /// <summary> The envelope settings. </summary>
        public AS2EnvelopeSettings EnvelopeSettings { get; set; }
        /// <summary> The error settings. </summary>
        public AS2ErrorSettings ErrorSettings { get; set; }
    }
}
