// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class AS2ProtocolSettings : IUtf8JsonSerializable, IJsonModel<AS2ProtocolSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AS2ProtocolSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AS2ProtocolSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ProtocolSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AS2ProtocolSettings)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("messageConnectionSettings"u8);
            writer.WriteObjectValue(MessageConnectionSettings, options);
            writer.WritePropertyName("acknowledgementConnectionSettings"u8);
            writer.WriteObjectValue(AcknowledgementConnectionSettings, options);
            writer.WritePropertyName("mdnSettings"u8);
            writer.WriteObjectValue(MdnSettings, options);
            writer.WritePropertyName("securitySettings"u8);
            writer.WriteObjectValue(SecuritySettings, options);
            writer.WritePropertyName("validationSettings"u8);
            writer.WriteObjectValue(ValidationSettings, options);
            writer.WritePropertyName("envelopeSettings"u8);
            writer.WriteObjectValue(EnvelopeSettings, options);
            writer.WritePropertyName("errorSettings"u8);
            writer.WriteObjectValue(ErrorSettings, options);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AS2ProtocolSettings IJsonModel<AS2ProtocolSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ProtocolSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AS2ProtocolSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAS2ProtocolSettings(document.RootElement, options);
        }

        internal static AS2ProtocolSettings DeserializeAS2ProtocolSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AS2MessageConnectionSettings messageConnectionSettings = default;
            AS2AcknowledgementConnectionSettings acknowledgementConnectionSettings = default;
            AS2MdnSettings mdnSettings = default;
            AS2SecuritySettings securitySettings = default;
            AS2ValidationSettings validationSettings = default;
            AS2EnvelopeSettings envelopeSettings = default;
            AS2ErrorSettings errorSettings = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("messageConnectionSettings"u8))
                {
                    messageConnectionSettings = AS2MessageConnectionSettings.DeserializeAS2MessageConnectionSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("acknowledgementConnectionSettings"u8))
                {
                    acknowledgementConnectionSettings = AS2AcknowledgementConnectionSettings.DeserializeAS2AcknowledgementConnectionSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("mdnSettings"u8))
                {
                    mdnSettings = AS2MdnSettings.DeserializeAS2MdnSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("securitySettings"u8))
                {
                    securitySettings = AS2SecuritySettings.DeserializeAS2SecuritySettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("validationSettings"u8))
                {
                    validationSettings = AS2ValidationSettings.DeserializeAS2ValidationSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("envelopeSettings"u8))
                {
                    envelopeSettings = AS2EnvelopeSettings.DeserializeAS2EnvelopeSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("errorSettings"u8))
                {
                    errorSettings = AS2ErrorSettings.DeserializeAS2ErrorSettings(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AS2ProtocolSettings(
                messageConnectionSettings,
                acknowledgementConnectionSettings,
                mdnSettings,
                securitySettings,
                validationSettings,
                envelopeSettings,
                errorSettings,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AS2ProtocolSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ProtocolSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AS2ProtocolSettings)} does not support writing '{options.Format}' format.");
            }
        }

        AS2ProtocolSettings IPersistableModel<AS2ProtocolSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ProtocolSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAS2ProtocolSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AS2ProtocolSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AS2ProtocolSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
