// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The signing or hashing algorithm. </summary>
    public readonly partial struct AS2HashingAlgorithm : IEquatable<AS2HashingAlgorithm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AS2HashingAlgorithm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AS2HashingAlgorithm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string NoneValue = "None";
        private const string MD5Value = "MD5";
        private const string Sha1Value = "SHA1";
        private const string Sha2256Value = "SHA2256";
        private const string Sha2384Value = "SHA2384";
        private const string Sha2512Value = "SHA2512";

        /// <summary> NotSpecified. </summary>
        public static AS2HashingAlgorithm NotSpecified { get; } = new AS2HashingAlgorithm(NotSpecifiedValue);
        /// <summary> None. </summary>
        public static AS2HashingAlgorithm None { get; } = new AS2HashingAlgorithm(NoneValue);
        /// <summary> MD5. </summary>
        public static AS2HashingAlgorithm MD5 { get; } = new AS2HashingAlgorithm(MD5Value);
        /// <summary> SHA1. </summary>
        public static AS2HashingAlgorithm Sha1 { get; } = new AS2HashingAlgorithm(Sha1Value);
        /// <summary> SHA2256. </summary>
        public static AS2HashingAlgorithm Sha2256 { get; } = new AS2HashingAlgorithm(Sha2256Value);
        /// <summary> SHA2384. </summary>
        public static AS2HashingAlgorithm Sha2384 { get; } = new AS2HashingAlgorithm(Sha2384Value);
        /// <summary> SHA2512. </summary>
        public static AS2HashingAlgorithm Sha2512 { get; } = new AS2HashingAlgorithm(Sha2512Value);
        /// <summary> Determines if two <see cref="AS2HashingAlgorithm"/> values are the same. </summary>
        public static bool operator ==(AS2HashingAlgorithm left, AS2HashingAlgorithm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AS2HashingAlgorithm"/> values are not the same. </summary>
        public static bool operator !=(AS2HashingAlgorithm left, AS2HashingAlgorithm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AS2HashingAlgorithm"/>. </summary>
        public static implicit operator AS2HashingAlgorithm(string value) => new AS2HashingAlgorithm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AS2HashingAlgorithm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AS2HashingAlgorithm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
