// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class AS2ErrorSettings : IUtf8JsonSerializable, IJsonModel<AS2ErrorSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AS2ErrorSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AS2ErrorSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ErrorSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AS2ErrorSettings)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("suspendDuplicateMessage"u8);
            writer.WriteBooleanValue(SuspendDuplicateMessage);
            writer.WritePropertyName("resendIfMDNNotReceived"u8);
            writer.WriteBooleanValue(ResendIfMdnNotReceived);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AS2ErrorSettings IJsonModel<AS2ErrorSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ErrorSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AS2ErrorSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAS2ErrorSettings(document.RootElement, options);
        }

        internal static AS2ErrorSettings DeserializeAS2ErrorSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool suspendDuplicateMessage = default;
            bool resendIfMdnNotReceived = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("suspendDuplicateMessage"u8))
                {
                    suspendDuplicateMessage = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("resendIfMDNNotReceived"u8))
                {
                    resendIfMdnNotReceived = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AS2ErrorSettings(suspendDuplicateMessage, resendIfMdnNotReceived, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AS2ErrorSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ErrorSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AS2ErrorSettings)} does not support writing '{options.Format}' format.");
            }
        }

        AS2ErrorSettings IPersistableModel<AS2ErrorSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2ErrorSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAS2ErrorSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AS2ErrorSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AS2ErrorSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
