// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Logic.Models
{
    public partial class AS2EnvelopeSettings : IUtf8JsonSerializable, IJsonModel<AS2EnvelopeSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AS2EnvelopeSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AS2EnvelopeSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2EnvelopeSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AS2EnvelopeSettings)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("messageContentType"u8);
            writer.WriteStringValue(MessageContentType.ToString());
            writer.WritePropertyName("transmitFileNameInMimeHeader"u8);
            writer.WriteBooleanValue(TransmitFileNameInMimeHeader);
            writer.WritePropertyName("fileNameTemplate"u8);
            writer.WriteStringValue(FileNameTemplate);
            writer.WritePropertyName("suspendMessageOnFileNameGenerationError"u8);
            writer.WriteBooleanValue(SuspendMessageOnFileNameGenerationError);
            writer.WritePropertyName("autogenerateFileName"u8);
            writer.WriteBooleanValue(AutoGenerateFileName);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        AS2EnvelopeSettings IJsonModel<AS2EnvelopeSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2EnvelopeSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AS2EnvelopeSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAS2EnvelopeSettings(document.RootElement, options);
        }

        internal static AS2EnvelopeSettings DeserializeAS2EnvelopeSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ContentType messageContentType = default;
            bool transmitFileNameInMimeHeader = default;
            string fileNameTemplate = default;
            bool suspendMessageOnFileNameGenerationError = default;
            bool autogenerateFileName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("messageContentType"u8))
                {
                    messageContentType = new ContentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("transmitFileNameInMimeHeader"u8))
                {
                    transmitFileNameInMimeHeader = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("fileNameTemplate"u8))
                {
                    fileNameTemplate = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("suspendMessageOnFileNameGenerationError"u8))
                {
                    suspendMessageOnFileNameGenerationError = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("autogenerateFileName"u8))
                {
                    autogenerateFileName = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AS2EnvelopeSettings(
                messageContentType,
                transmitFileNameInMimeHeader,
                fileNameTemplate,
                suspendMessageOnFileNameGenerationError,
                autogenerateFileName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AS2EnvelopeSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2EnvelopeSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AS2EnvelopeSettings)} does not support writing '{options.Format}' format.");
            }
        }

        AS2EnvelopeSettings IPersistableModel<AS2EnvelopeSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AS2EnvelopeSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAS2EnvelopeSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AS2EnvelopeSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AS2EnvelopeSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
