// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> The encryption algorithm. </summary>
    public readonly partial struct AS2EncryptionAlgorithm : IEquatable<AS2EncryptionAlgorithm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AS2EncryptionAlgorithm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AS2EncryptionAlgorithm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string NoneValue = "None";
        private const string Des3Value = "DES3";
        private const string RC2Value = "RC2";
        private const string Aes128Value = "AES128";
        private const string Aes192Value = "AES192";
        private const string Aes256Value = "AES256";

        /// <summary> NotSpecified. </summary>
        public static AS2EncryptionAlgorithm NotSpecified { get; } = new AS2EncryptionAlgorithm(NotSpecifiedValue);
        /// <summary> None. </summary>
        public static AS2EncryptionAlgorithm None { get; } = new AS2EncryptionAlgorithm(NoneValue);
        /// <summary> DES3. </summary>
        public static AS2EncryptionAlgorithm Des3 { get; } = new AS2EncryptionAlgorithm(Des3Value);
        /// <summary> RC2. </summary>
        public static AS2EncryptionAlgorithm RC2 { get; } = new AS2EncryptionAlgorithm(RC2Value);
        /// <summary> AES128. </summary>
        public static AS2EncryptionAlgorithm Aes128 { get; } = new AS2EncryptionAlgorithm(Aes128Value);
        /// <summary> AES192. </summary>
        public static AS2EncryptionAlgorithm Aes192 { get; } = new AS2EncryptionAlgorithm(Aes192Value);
        /// <summary> AES256. </summary>
        public static AS2EncryptionAlgorithm Aes256 { get; } = new AS2EncryptionAlgorithm(Aes256Value);
        /// <summary> Determines if two <see cref="AS2EncryptionAlgorithm"/> values are the same. </summary>
        public static bool operator ==(AS2EncryptionAlgorithm left, AS2EncryptionAlgorithm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AS2EncryptionAlgorithm"/> values are not the same. </summary>
        public static bool operator !=(AS2EncryptionAlgorithm left, AS2EncryptionAlgorithm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AS2EncryptionAlgorithm"/>. </summary>
        public static implicit operator AS2EncryptionAlgorithm(string value) => new AS2EncryptionAlgorithm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AS2EncryptionAlgorithm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AS2EncryptionAlgorithm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
