// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Logic
{
    internal class IntegrationServiceEnvironmentManagedApiOperationSource : IOperationSource<IntegrationServiceEnvironmentManagedApiResource>
    {
        private readonly ArmClient _client;

        internal IntegrationServiceEnvironmentManagedApiOperationSource(ArmClient client)
        {
            _client = client;
        }

        IntegrationServiceEnvironmentManagedApiResource IOperationSource<IntegrationServiceEnvironmentManagedApiResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = IntegrationServiceEnvironmentManagedApiData.DeserializeIntegrationServiceEnvironmentManagedApiData(document.RootElement);
            return new IntegrationServiceEnvironmentManagedApiResource(_client, data);
        }

        async ValueTask<IntegrationServiceEnvironmentManagedApiResource> IOperationSource<IntegrationServiceEnvironmentManagedApiResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = IntegrationServiceEnvironmentManagedApiData.DeserializeIntegrationServiceEnvironmentManagedApiData(document.RootElement);
            return new IntegrationServiceEnvironmentManagedApiResource(_client, data);
        }
    }
}
