// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Logic.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Logic
{
    /// <summary>
    /// A class representing the LogicWorkflowTrigger data model.
    /// The workflow trigger.
    /// </summary>
    public partial class LogicWorkflowTriggerData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerData"/>. </summary>
        internal LogicWorkflowTriggerData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LogicWorkflowTriggerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Gets the provisioning state. </param>
        /// <param name="createdOn"> Gets the created time. </param>
        /// <param name="changedOn"> Gets the changed time. </param>
        /// <param name="state"> Gets the state. </param>
        /// <param name="status"> Gets the status. </param>
        /// <param name="lastExecutionOn"> Gets the last execution time. </param>
        /// <param name="nextExecutionOn"> Gets the next execution time. </param>
        /// <param name="recurrence"> Gets the workflow trigger recurrence. </param>
        /// <param name="workflow"> Gets the reference to workflow. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogicWorkflowTriggerData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, LogicWorkflowTriggerProvisioningState? provisioningState, DateTimeOffset? createdOn, DateTimeOffset? changedOn, LogicWorkflowState? state, LogicWorkflowStatus? status, DateTimeOffset? lastExecutionOn, DateTimeOffset? nextExecutionOn, LogicWorkflowTriggerRecurrence recurrence, LogicResourceReference workflow, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            CreatedOn = createdOn;
            ChangedOn = changedOn;
            State = state;
            Status = status;
            LastExecutionOn = lastExecutionOn;
            NextExecutionOn = nextExecutionOn;
            Recurrence = recurrence;
            Workflow = workflow;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provisioning state. </summary>
        public LogicWorkflowTriggerProvisioningState? ProvisioningState { get; }
        /// <summary> Gets the created time. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Gets the changed time. </summary>
        public DateTimeOffset? ChangedOn { get; }
        /// <summary> Gets the state. </summary>
        public LogicWorkflowState? State { get; }
        /// <summary> Gets the status. </summary>
        public LogicWorkflowStatus? Status { get; }
        /// <summary> Gets the last execution time. </summary>
        public DateTimeOffset? LastExecutionOn { get; }
        /// <summary> Gets the next execution time. </summary>
        public DateTimeOffset? NextExecutionOn { get; }
        /// <summary> Gets the workflow trigger recurrence. </summary>
        public LogicWorkflowTriggerRecurrence Recurrence { get; }
        /// <summary> Gets the reference to workflow. </summary>
        public LogicResourceReference Workflow { get; }
    }
}
