// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Logic.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Logic
{
    /// <summary>
    /// A class representing the IntegrationAccount data model.
    /// The integration account.
    /// </summary>
    public partial class IntegrationAccountData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountData"/>. </summary>
        /// <param name="location"> The location. </param>
        public IntegrationAccountData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="integrationServiceEnvironment"> The integration service environment. </param>
        /// <param name="state"> The workflow state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IntegrationAccountData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, IntegrationAccountSku sku, LogicResourceReference integrationServiceEnvironment, LogicWorkflowState? state, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            IntegrationServiceEnvironment = integrationServiceEnvironment;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="IntegrationAccountData"/> for deserialization. </summary>
        internal IntegrationAccountData()
        {
        }

        /// <summary> The sku. </summary>
        internal IntegrationAccountSku Sku { get; set; }
        /// <summary> The sku name. </summary>
        public IntegrationAccountSkuName? SkuName
        {
            get => Sku is null ? default(IntegrationAccountSkuName?) : Sku.Name;
            set
            {
                Sku = value.HasValue ? new IntegrationAccountSku(value.Value) : null;
            }
        }

        /// <summary> The integration service environment. </summary>
        public LogicResourceReference IntegrationServiceEnvironment { get; set; }
        /// <summary> The workflow state. </summary>
        public LogicWorkflowState? State { get; set; }
    }
}
