// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Logic
{
    /// <summary>
    /// A class representing a collection of <see cref="IntegrationAccountAssemblyDefinitionResource"/> and their operations.
    /// Each <see cref="IntegrationAccountAssemblyDefinitionResource"/> in the collection will belong to the same instance of <see cref="IntegrationAccountResource"/>.
    /// To get an <see cref="IntegrationAccountAssemblyDefinitionCollection"/> instance call the GetIntegrationAccountAssemblyDefinitions method from an instance of <see cref="IntegrationAccountResource"/>.
    /// </summary>
    public partial class IntegrationAccountAssemblyDefinitionCollection : ArmCollection, IEnumerable<IntegrationAccountAssemblyDefinitionResource>, IAsyncEnumerable<IntegrationAccountAssemblyDefinitionResource>
    {
        private readonly ClientDiagnostics _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics;
        private readonly IntegrationAccountAssembliesRestOperations _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient;

        /// <summary> Initializes a new instance of the <see cref="IntegrationAccountAssemblyDefinitionCollection"/> class for mocking. </summary>
        protected IntegrationAccountAssemblyDefinitionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="IntegrationAccountAssemblyDefinitionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal IntegrationAccountAssemblyDefinitionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Logic", IntegrationAccountAssemblyDefinitionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(IntegrationAccountAssemblyDefinitionResource.ResourceType, out string integrationAccountAssemblyDefinitionIntegrationAccountAssembliesApiVersion);
            _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient = new IntegrationAccountAssembliesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, integrationAccountAssemblyDefinitionIntegrationAccountAssembliesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != IntegrationAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, IntegrationAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update an assembly for an integration account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="data"> The assembly artifact. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<IntegrationAccountAssemblyDefinitionResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string assemblyArtifactName, IntegrationAccountAssemblyDefinitionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, data, cancellationToken).ConfigureAwait(false);
                var uri = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new LogicArmOperation<IntegrationAccountAssemblyDefinitionResource>(Response.FromValue(new IntegrationAccountAssemblyDefinitionResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update an assembly for an integration account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="data"> The assembly artifact. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<IntegrationAccountAssemblyDefinitionResource> CreateOrUpdate(WaitUntil waitUntil, string assemblyArtifactName, IntegrationAccountAssemblyDefinitionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, data, cancellationToken);
                var uri = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new LogicArmOperation<IntegrationAccountAssemblyDefinitionResource>(Response.FromValue(new IntegrationAccountAssemblyDefinitionResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get an assembly for an integration account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> is null. </exception>
        public virtual async Task<Response<IntegrationAccountAssemblyDefinitionResource>> GetAsync(string assemblyArtifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.Get");
            scope.Start();
            try
            {
                var response = await _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAssemblyDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get an assembly for an integration account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> is null. </exception>
        public virtual Response<IntegrationAccountAssemblyDefinitionResource> Get(string assemblyArtifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.Get");
            scope.Start();
            try
            {
                var response = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAssemblyDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List the assemblies for an integration account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="IntegrationAccountAssemblyDefinitionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<IntegrationAccountAssemblyDefinitionResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new IntegrationAccountAssemblyDefinitionResource(Client, IntegrationAccountAssemblyDefinitionData.DeserializeIntegrationAccountAssemblyDefinitionData(e)), _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics, Pipeline, "IntegrationAccountAssemblyDefinitionCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// List the assemblies for an integration account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="IntegrationAccountAssemblyDefinitionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<IntegrationAccountAssemblyDefinitionResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new IntegrationAccountAssemblyDefinitionResource(Client, IntegrationAccountAssemblyDefinitionData.DeserializeIntegrationAccountAssemblyDefinitionData(e)), _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics, Pipeline, "IntegrationAccountAssemblyDefinitionCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string assemblyArtifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> is null. </exception>
        public virtual Response<bool> Exists(string assemblyArtifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.Exists");
            scope.Start();
            try
            {
                var response = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> is null. </exception>
        public virtual async Task<NullableResponse<IntegrationAccountAssemblyDefinitionResource>> GetIfExistsAsync(string assemblyArtifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<IntegrationAccountAssemblyDefinitionResource>(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAssemblyDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/assemblies/{assemblyArtifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAssemblies_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAssemblyDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assemblyArtifactName"> The assembly artifact name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assemblyArtifactName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assemblyArtifactName"/> is null. </exception>
        public virtual NullableResponse<IntegrationAccountAssemblyDefinitionResource> GetIfExists(string assemblyArtifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assemblyArtifactName, nameof(assemblyArtifactName));

            using var scope = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesClientDiagnostics.CreateScope("IntegrationAccountAssemblyDefinitionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _integrationAccountAssemblyDefinitionIntegrationAccountAssembliesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, assemblyArtifactName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<IntegrationAccountAssemblyDefinitionResource>(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAssemblyDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<IntegrationAccountAssemblyDefinitionResource> IEnumerable<IntegrationAccountAssemblyDefinitionResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<IntegrationAccountAssemblyDefinitionResource> IAsyncEnumerable<IntegrationAccountAssemblyDefinitionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
