// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Logic
{
    /// <summary>
    /// A class representing a collection of <see cref="IntegrationAccountAgreementResource"/> and their operations.
    /// Each <see cref="IntegrationAccountAgreementResource"/> in the collection will belong to the same instance of <see cref="IntegrationAccountResource"/>.
    /// To get an <see cref="IntegrationAccountAgreementCollection"/> instance call the GetIntegrationAccountAgreements method from an instance of <see cref="IntegrationAccountResource"/>.
    /// </summary>
    public partial class IntegrationAccountAgreementCollection : ArmCollection, IEnumerable<IntegrationAccountAgreementResource>, IAsyncEnumerable<IntegrationAccountAgreementResource>
    {
        private readonly ClientDiagnostics _integrationAccountAgreementClientDiagnostics;
        private readonly IntegrationAccountAgreementsRestOperations _integrationAccountAgreementRestClient;

        /// <summary> Initializes a new instance of the <see cref="IntegrationAccountAgreementCollection"/> class for mocking. </summary>
        protected IntegrationAccountAgreementCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="IntegrationAccountAgreementCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal IntegrationAccountAgreementCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _integrationAccountAgreementClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Logic", IntegrationAccountAgreementResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(IntegrationAccountAgreementResource.ResourceType, out string integrationAccountAgreementApiVersion);
            _integrationAccountAgreementRestClient = new IntegrationAccountAgreementsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, integrationAccountAgreementApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != IntegrationAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, IntegrationAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates an integration account agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="data"> The integration account agreement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<IntegrationAccountAgreementResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string agreementName, IntegrationAccountAgreementData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _integrationAccountAgreementRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, data, cancellationToken).ConfigureAwait(false);
                var uri = _integrationAccountAgreementRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new LogicArmOperation<IntegrationAccountAgreementResource>(Response.FromValue(new IntegrationAccountAgreementResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates an integration account agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="data"> The integration account agreement. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<IntegrationAccountAgreementResource> CreateOrUpdate(WaitUntil waitUntil, string agreementName, IntegrationAccountAgreementData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _integrationAccountAgreementRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, data, cancellationToken);
                var uri = _integrationAccountAgreementRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new LogicArmOperation<IntegrationAccountAgreementResource>(Response.FromValue(new IntegrationAccountAgreementResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an integration account agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> is null. </exception>
        public virtual async Task<Response<IntegrationAccountAgreementResource>> GetAsync(string agreementName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.Get");
            scope.Start();
            try
            {
                var response = await _integrationAccountAgreementRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAgreementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an integration account agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> is null. </exception>
        public virtual Response<IntegrationAccountAgreementResource> Get(string agreementName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.Get");
            scope.Start();
            try
            {
                var response = _integrationAccountAgreementRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAgreementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of integration account agreements.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> The number of items to be included in the result. </param>
        /// <param name="filter"> The filter to apply on the operation. Options for filters include: AgreementType. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="IntegrationAccountAgreementResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<IntegrationAccountAgreementResource> GetAllAsync(int? top = null, string filter = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _integrationAccountAgreementRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _integrationAccountAgreementRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top, filter);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new IntegrationAccountAgreementResource(Client, IntegrationAccountAgreementData.DeserializeIntegrationAccountAgreementData(e)), _integrationAccountAgreementClientDiagnostics, Pipeline, "IntegrationAccountAgreementCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of integration account agreements.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="top"> The number of items to be included in the result. </param>
        /// <param name="filter"> The filter to apply on the operation. Options for filters include: AgreementType. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="IntegrationAccountAgreementResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<IntegrationAccountAgreementResource> GetAll(int? top = null, string filter = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _integrationAccountAgreementRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _integrationAccountAgreementRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, top, filter);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new IntegrationAccountAgreementResource(Client, IntegrationAccountAgreementData.DeserializeIntegrationAccountAgreementData(e)), _integrationAccountAgreementClientDiagnostics, Pipeline, "IntegrationAccountAgreementCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string agreementName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.Exists");
            scope.Start();
            try
            {
                var response = await _integrationAccountAgreementRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> is null. </exception>
        public virtual Response<bool> Exists(string agreementName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.Exists");
            scope.Start();
            try
            {
                var response = _integrationAccountAgreementRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> is null. </exception>
        public virtual async Task<NullableResponse<IntegrationAccountAgreementResource>> GetIfExistsAsync(string agreementName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _integrationAccountAgreementRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<IntegrationAccountAgreementResource>(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAgreementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IntegrationAccountAgreements_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2019-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="IntegrationAccountAgreementResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="agreementName"> The integration account agreement name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="agreementName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="agreementName"/> is null. </exception>
        public virtual NullableResponse<IntegrationAccountAgreementResource> GetIfExists(string agreementName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(agreementName, nameof(agreementName));

            using var scope = _integrationAccountAgreementClientDiagnostics.CreateScope("IntegrationAccountAgreementCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _integrationAccountAgreementRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, agreementName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<IntegrationAccountAgreementResource>(response.GetRawResponse());
                return Response.FromValue(new IntegrationAccountAgreementResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<IntegrationAccountAgreementResource> IEnumerable<IntegrationAccountAgreementResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<IntegrationAccountAgreementResource> IAsyncEnumerable<IntegrationAccountAgreementResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
