// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Logic.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableLogicArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableLogicArmClient"/> class for mocking. </summary>
        protected MockableLogicArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableLogicArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableLogicArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableLogicArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowResource"/> object. </returns>
        public virtual LogicWorkflowResource GetLogicWorkflowResource(ResourceIdentifier id)
        {
            LogicWorkflowResource.ValidateResourceId(id);
            return new LogicWorkflowResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowVersionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowVersionResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowVersionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowVersionResource"/> object. </returns>
        public virtual LogicWorkflowVersionResource GetLogicWorkflowVersionResource(ResourceIdentifier id)
        {
            LogicWorkflowVersionResource.ValidateResourceId(id);
            return new LogicWorkflowVersionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowTriggerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowTriggerResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowTriggerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowTriggerResource"/> object. </returns>
        public virtual LogicWorkflowTriggerResource GetLogicWorkflowTriggerResource(ResourceIdentifier id)
        {
            LogicWorkflowTriggerResource.ValidateResourceId(id);
            return new LogicWorkflowTriggerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowTriggerHistoryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowTriggerHistoryResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowTriggerHistoryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowTriggerHistoryResource"/> object. </returns>
        public virtual LogicWorkflowTriggerHistoryResource GetLogicWorkflowTriggerHistoryResource(ResourceIdentifier id)
        {
            LogicWorkflowTriggerHistoryResource.ValidateResourceId(id);
            return new LogicWorkflowTriggerHistoryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunResource"/> object. </returns>
        public virtual LogicWorkflowRunResource GetLogicWorkflowRunResource(ResourceIdentifier id)
        {
            LogicWorkflowRunResource.ValidateResourceId(id);
            return new LogicWorkflowRunResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunOperationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunOperationResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunOperationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunOperationResource"/> object. </returns>
        public virtual LogicWorkflowRunOperationResource GetLogicWorkflowRunOperationResource(ResourceIdentifier id)
        {
            LogicWorkflowRunOperationResource.ValidateResourceId(id);
            return new LogicWorkflowRunOperationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunActionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunActionResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunActionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunActionResource"/> object. </returns>
        public virtual LogicWorkflowRunActionResource GetLogicWorkflowRunActionResource(ResourceIdentifier id)
        {
            LogicWorkflowRunActionResource.ValidateResourceId(id);
            return new LogicWorkflowRunActionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunActionRepetitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunActionRepetitionResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunActionRepetitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunActionRepetitionResource"/> object. </returns>
        public virtual LogicWorkflowRunActionRepetitionResource GetLogicWorkflowRunActionRepetitionResource(ResourceIdentifier id)
        {
            LogicWorkflowRunActionRepetitionResource.ValidateResourceId(id);
            return new LogicWorkflowRunActionRepetitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunActionScopeRepetitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunActionScopeRepetitionResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunActionScopeRepetitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunActionScopeRepetitionResource"/> object. </returns>
        public virtual LogicWorkflowRunActionScopeRepetitionResource GetLogicWorkflowRunActionScopeRepetitionResource(ResourceIdentifier id)
        {
            LogicWorkflowRunActionScopeRepetitionResource.ValidateResourceId(id);
            return new LogicWorkflowRunActionScopeRepetitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunActionRepetitionRequestHistoryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunActionRepetitionRequestHistoryResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunActionRepetitionRequestHistoryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunActionRepetitionRequestHistoryResource"/> object. </returns>
        public virtual LogicWorkflowRunActionRepetitionRequestHistoryResource GetLogicWorkflowRunActionRepetitionRequestHistoryResource(ResourceIdentifier id)
        {
            LogicWorkflowRunActionRepetitionRequestHistoryResource.ValidateResourceId(id);
            return new LogicWorkflowRunActionRepetitionRequestHistoryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="LogicWorkflowRunActionRequestHistoryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="LogicWorkflowRunActionRequestHistoryResource.CreateResourceIdentifier" /> to create a <see cref="LogicWorkflowRunActionRequestHistoryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="LogicWorkflowRunActionRequestHistoryResource"/> object. </returns>
        public virtual LogicWorkflowRunActionRequestHistoryResource GetLogicWorkflowRunActionRequestHistoryResource(ResourceIdentifier id)
        {
            LogicWorkflowRunActionRequestHistoryResource.ValidateResourceId(id);
            return new LogicWorkflowRunActionRequestHistoryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountResource"/> object. </returns>
        public virtual IntegrationAccountResource GetIntegrationAccountResource(ResourceIdentifier id)
        {
            IntegrationAccountResource.ValidateResourceId(id);
            return new IntegrationAccountResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountAssemblyDefinitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountAssemblyDefinitionResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountAssemblyDefinitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountAssemblyDefinitionResource"/> object. </returns>
        public virtual IntegrationAccountAssemblyDefinitionResource GetIntegrationAccountAssemblyDefinitionResource(ResourceIdentifier id)
        {
            IntegrationAccountAssemblyDefinitionResource.ValidateResourceId(id);
            return new IntegrationAccountAssemblyDefinitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountBatchConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountBatchConfigurationResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountBatchConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountBatchConfigurationResource"/> object. </returns>
        public virtual IntegrationAccountBatchConfigurationResource GetIntegrationAccountBatchConfigurationResource(ResourceIdentifier id)
        {
            IntegrationAccountBatchConfigurationResource.ValidateResourceId(id);
            return new IntegrationAccountBatchConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountSchemaResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountSchemaResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountSchemaResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountSchemaResource"/> object. </returns>
        public virtual IntegrationAccountSchemaResource GetIntegrationAccountSchemaResource(ResourceIdentifier id)
        {
            IntegrationAccountSchemaResource.ValidateResourceId(id);
            return new IntegrationAccountSchemaResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountMapResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountMapResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountMapResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountMapResource"/> object. </returns>
        public virtual IntegrationAccountMapResource GetIntegrationAccountMapResource(ResourceIdentifier id)
        {
            IntegrationAccountMapResource.ValidateResourceId(id);
            return new IntegrationAccountMapResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountPartnerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountPartnerResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountPartnerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountPartnerResource"/> object. </returns>
        public virtual IntegrationAccountPartnerResource GetIntegrationAccountPartnerResource(ResourceIdentifier id)
        {
            IntegrationAccountPartnerResource.ValidateResourceId(id);
            return new IntegrationAccountPartnerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountAgreementResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountAgreementResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountAgreementResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountAgreementResource"/> object. </returns>
        public virtual IntegrationAccountAgreementResource GetIntegrationAccountAgreementResource(ResourceIdentifier id)
        {
            IntegrationAccountAgreementResource.ValidateResourceId(id);
            return new IntegrationAccountAgreementResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountCertificateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountCertificateResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountCertificateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountCertificateResource"/> object. </returns>
        public virtual IntegrationAccountCertificateResource GetIntegrationAccountCertificateResource(ResourceIdentifier id)
        {
            IntegrationAccountCertificateResource.ValidateResourceId(id);
            return new IntegrationAccountCertificateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationAccountSessionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationAccountSessionResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationAccountSessionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationAccountSessionResource"/> object. </returns>
        public virtual IntegrationAccountSessionResource GetIntegrationAccountSessionResource(ResourceIdentifier id)
        {
            IntegrationAccountSessionResource.ValidateResourceId(id);
            return new IntegrationAccountSessionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationServiceEnvironmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationServiceEnvironmentResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationServiceEnvironmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationServiceEnvironmentResource"/> object. </returns>
        public virtual IntegrationServiceEnvironmentResource GetIntegrationServiceEnvironmentResource(ResourceIdentifier id)
        {
            IntegrationServiceEnvironmentResource.ValidateResourceId(id);
            return new IntegrationServiceEnvironmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="IntegrationServiceEnvironmentManagedApiResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="IntegrationServiceEnvironmentManagedApiResource.CreateResourceIdentifier" /> to create an <see cref="IntegrationServiceEnvironmentManagedApiResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="IntegrationServiceEnvironmentManagedApiResource"/> object. </returns>
        public virtual IntegrationServiceEnvironmentManagedApiResource GetIntegrationServiceEnvironmentManagedApiResource(ResourceIdentifier id)
        {
            IntegrationServiceEnvironmentManagedApiResource.ValidateResourceId(id);
            return new IntegrationServiceEnvironmentManagedApiResource(Client, id);
        }
    }
}
