// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Logic.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmLogicModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Managed service identity properties. Current supported identity types: SystemAssigned, UserAssigned, None. </param>
        /// <param name="provisioningState"> Gets the provisioning state. </param>
        /// <param name="createdOn"> Gets the created time. </param>
        /// <param name="changedOn"> Gets the changed time. </param>
        /// <param name="state"> The state. </param>
        /// <param name="version"> Gets the version. </param>
        /// <param name="accessEndpoint"> Gets the access endpoint. </param>
        /// <param name="endpointsConfiguration"> The endpoints configuration. </param>
        /// <param name="accessControl"> The access control configuration. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="integrationAccount"> The integration account. </param>
        /// <param name="integrationServiceEnvironment"> The integration service environment. </param>
        /// <param name="definition"> The definition. </param>
        /// <param name="parameters"> The parameters. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowData"/> instance for mocking. </returns>
        public static LogicWorkflowData LogicWorkflowData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, LogicWorkflowProvisioningState? provisioningState = null, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, LogicWorkflowState? state = null, string version = null, string accessEndpoint = null, FlowEndpointsConfiguration endpointsConfiguration = null, FlowAccessControlConfiguration accessControl = null, LogicSku sku = null, LogicResourceReference integrationAccount = null, LogicResourceReference integrationServiceEnvironment = null, BinaryData definition = null, IDictionary<string, LogicWorkflowParameterInfo> parameters = null)
        {
            tags ??= new Dictionary<string, string>();
            parameters ??= new Dictionary<string, LogicWorkflowParameterInfo>();

            return new LogicWorkflowData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                provisioningState,
                createdOn,
                changedOn,
                state,
                version,
                accessEndpoint,
                endpointsConfiguration,
                accessControl,
                sku,
                integrationAccount,
                integrationServiceEnvironment,
                definition,
                parameters,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicSku"/>. </summary>
        /// <param name="name"> The name. </param>
        /// <param name="plan"> The reference to plan. </param>
        /// <returns> A new <see cref="Models.LogicSku"/> instance for mocking. </returns>
        public static LogicSku LogicSku(LogicSkuName name = default, LogicResourceReference plan = null)
        {
            return new LogicSku(name, plan, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicResourceReference"/>. </summary>
        /// <param name="id"> The resource id. </param>
        /// <param name="name"> Gets the resource name. </param>
        /// <param name="resourceType"> Gets the resource type. </param>
        /// <returns> A new <see cref="Models.LogicResourceReference"/> instance for mocking. </returns>
        public static LogicResourceReference LogicResourceReference(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null)
        {
            return new LogicResourceReference(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWorkflowTriggerCallbackUri"/>. </summary>
        /// <param name="value"> Gets the workflow trigger callback URL. </param>
        /// <param name="method"> Gets the workflow trigger callback URL HTTP method. </param>
        /// <param name="basePath"> Gets the workflow trigger callback URL base path. </param>
        /// <param name="relativePath"> Gets the workflow trigger callback URL relative path. </param>
        /// <param name="relativePathParameters"> Gets the workflow trigger callback URL relative path parameters. </param>
        /// <param name="queries"> Gets the workflow trigger callback URL query parameters. </param>
        /// <returns> A new <see cref="Models.LogicWorkflowTriggerCallbackUri"/> instance for mocking. </returns>
        public static LogicWorkflowTriggerCallbackUri LogicWorkflowTriggerCallbackUri(string value = null, RequestMethod? method = null, string basePath = null, string relativePath = null, IEnumerable<string> relativePathParameters = null, LogicWorkflowTriggerCallbackQueryParameterInfo queries = null)
        {
            relativePathParameters ??= new List<string>();

            return new LogicWorkflowTriggerCallbackUri(
                value,
                method,
                basePath,
                relativePath,
                relativePathParameters?.ToList(),
                queries,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWorkflowTriggerCallbackQueryParameterInfo"/>. </summary>
        /// <param name="apiVersion"> The api version. </param>
        /// <param name="sp"> The SAS permissions. </param>
        /// <param name="sv"> The SAS version. </param>
        /// <param name="sig"> The SAS signature. </param>
        /// <param name="se"> The SAS timestamp. </param>
        /// <returns> A new <see cref="Models.LogicWorkflowTriggerCallbackQueryParameterInfo"/> instance for mocking. </returns>
        public static LogicWorkflowTriggerCallbackQueryParameterInfo LogicWorkflowTriggerCallbackQueryParameterInfo(string apiVersion = null, string sp = null, string sv = null, string sig = null, string se = null)
        {
            return new LogicWorkflowTriggerCallbackQueryParameterInfo(
                apiVersion,
                sp,
                sv,
                sig,
                se,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWorkflowReference"/>. </summary>
        /// <param name="id"> The resource id. </param>
        /// <param name="name"> Gets the resource name. </param>
        /// <param name="resourceType"> Gets the resource type. </param>
        /// <returns> A new <see cref="Models.LogicWorkflowReference"/> instance for mocking. </returns>
        public static LogicWorkflowReference LogicWorkflowReference(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null)
        {
            return new LogicWorkflowReference(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowVersionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="createdOn"> Gets the created time. </param>
        /// <param name="changedOn"> Gets the changed time. </param>
        /// <param name="state"> The state. </param>
        /// <param name="version"> Gets the version. </param>
        /// <param name="accessEndpoint"> Gets the access endpoint. </param>
        /// <param name="endpointsConfiguration"> The endpoints configuration. </param>
        /// <param name="accessControl"> The access control configuration. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="integrationAccount"> The integration account. </param>
        /// <param name="definition"> The definition. </param>
        /// <param name="parameters"> The parameters. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowVersionData"/> instance for mocking. </returns>
        public static LogicWorkflowVersionData LogicWorkflowVersionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, LogicWorkflowProvisioningState? provisioningState = null, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, LogicWorkflowState? state = null, string version = null, string accessEndpoint = null, FlowEndpointsConfiguration endpointsConfiguration = null, FlowAccessControlConfiguration accessControl = null, LogicSku sku = null, LogicResourceReference integrationAccount = null, BinaryData definition = null, IDictionary<string, LogicWorkflowParameterInfo> parameters = null)
        {
            tags ??= new Dictionary<string, string>();
            parameters ??= new Dictionary<string, LogicWorkflowParameterInfo>();

            return new LogicWorkflowVersionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                createdOn,
                changedOn,
                state,
                version,
                accessEndpoint,
                endpointsConfiguration,
                accessControl,
                sku,
                integrationAccount,
                definition,
                parameters,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowTriggerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Gets the provisioning state. </param>
        /// <param name="createdOn"> Gets the created time. </param>
        /// <param name="changedOn"> Gets the changed time. </param>
        /// <param name="state"> Gets the state. </param>
        /// <param name="status"> Gets the status. </param>
        /// <param name="lastExecutionOn"> Gets the last execution time. </param>
        /// <param name="nextExecutionOn"> Gets the next execution time. </param>
        /// <param name="recurrence"> Gets the workflow trigger recurrence. </param>
        /// <param name="workflow"> Gets the reference to workflow. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowTriggerData"/> instance for mocking. </returns>
        public static LogicWorkflowTriggerData LogicWorkflowTriggerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, LogicWorkflowTriggerProvisioningState? provisioningState = null, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, LogicWorkflowState? state = null, LogicWorkflowStatus? status = null, DateTimeOffset? lastExecutionOn = null, DateTimeOffset? nextExecutionOn = null, LogicWorkflowTriggerRecurrence recurrence = null, LogicResourceReference workflow = null)
        {
            return new LogicWorkflowTriggerData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                createdOn,
                changedOn,
                state,
                status,
                lastExecutionOn,
                nextExecutionOn,
                recurrence,
                workflow,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicJsonSchema"/>. </summary>
        /// <param name="title"> The JSON title. </param>
        /// <param name="content"> The JSON content. </param>
        /// <returns> A new <see cref="Models.LogicJsonSchema"/> instance for mocking. </returns>
        public static LogicJsonSchema LogicJsonSchema(string title = null, BinaryData content = null)
        {
            return new LogicJsonSchema(title, content, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWorkflowTriggerReference"/>. </summary>
        /// <param name="id"> The resource id. </param>
        /// <param name="name"> Gets the resource name. </param>
        /// <param name="resourceType"> Gets the resource type. </param>
        /// <param name="flowName"> The workflow name. </param>
        /// <param name="triggerName"> The workflow trigger name. </param>
        /// <returns> A new <see cref="Models.LogicWorkflowTriggerReference"/> instance for mocking. </returns>
        public static LogicWorkflowTriggerReference LogicWorkflowTriggerReference(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, string flowName = null, string triggerName = null)
        {
            return new LogicWorkflowTriggerReference(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                flowName,
                triggerName);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowTriggerHistoryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="startOn"> Gets the start time. </param>
        /// <param name="endOn"> Gets the end time. </param>
        /// <param name="scheduledOn"> The scheduled time. </param>
        /// <param name="status"> Gets the status. </param>
        /// <param name="code"> Gets the code. </param>
        /// <param name="error"> Gets the error. </param>
        /// <param name="trackingId"> Gets the tracking id. </param>
        /// <param name="correlationClientTrackingId"> The run correlation. </param>
        /// <param name="inputsLink"> Gets the link to input parameters. </param>
        /// <param name="outputsLink"> Gets the link to output parameters. </param>
        /// <param name="isFired"> The value indicating whether trigger was fired. </param>
        /// <param name="run"> Gets the reference to workflow run. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowTriggerHistoryData"/> instance for mocking. </returns>
        public static LogicWorkflowTriggerHistoryData LogicWorkflowTriggerHistoryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, DateTimeOffset? scheduledOn = null, LogicWorkflowStatus? status = null, string code = null, BinaryData error = null, Guid? trackingId = null, string correlationClientTrackingId = null, LogicContentLink inputsLink = null, LogicContentLink outputsLink = null, bool? isFired = null, LogicResourceReference run = null)
        {
            return new LogicWorkflowTriggerHistoryData(
                id,
                name,
                resourceType,
                systemData,
                startOn,
                endOn,
                scheduledOn,
                status,
                code,
                error,
                trackingId,
                correlationClientTrackingId != null ? new Correlation(correlationClientTrackingId, serializedAdditionalRawData: null) : null,
                inputsLink,
                outputsLink,
                isFired,
                run,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicContentLink"/>. </summary>
        /// <param name="uri"> The content link URI. </param>
        /// <param name="contentVersion"> The content version. </param>
        /// <param name="contentSize"> The content size. </param>
        /// <param name="contentHash"> The content hash. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <returns> A new <see cref="Models.LogicContentLink"/> instance for mocking. </returns>
        public static LogicContentLink LogicContentLink(Uri uri = null, string contentVersion = null, long? contentSize = null, LogicContentHash contentHash = null, BinaryData metadata = null)
        {
            return new LogicContentLink(
                uri,
                contentVersion,
                contentSize,
                contentHash,
                metadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicContentHash"/>. </summary>
        /// <param name="algorithm"> The algorithm of the content hash. </param>
        /// <param name="value"> The value of the content hash. </param>
        /// <returns> A new <see cref="Models.LogicContentHash"/> instance for mocking. </returns>
        public static LogicContentHash LogicContentHash(string algorithm = null, string value = null)
        {
            return new LogicContentHash(algorithm, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowRunData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="waitEndOn"> Gets the wait end time. </param>
        /// <param name="startOn"> Gets the start time. </param>
        /// <param name="endOn"> Gets the end time. </param>
        /// <param name="status"> Gets the status. </param>
        /// <param name="code"> Gets the code. </param>
        /// <param name="error"> Gets the error. </param>
        /// <param name="correlationId"> Gets the correlation id. </param>
        /// <param name="correlationClientTrackingId"> The run correlation. </param>
        /// <param name="workflow"> Gets the reference to workflow version. </param>
        /// <param name="trigger"> Gets the fired trigger. </param>
        /// <param name="outputs"> Gets the outputs. </param>
        /// <param name="response"> Gets the response of the flow run. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowRunData"/> instance for mocking. </returns>
        public static LogicWorkflowRunData LogicWorkflowRunData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? waitEndOn = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, LogicWorkflowStatus? status = null, string code = null, BinaryData error = null, string correlationId = null, string correlationClientTrackingId = null, LogicResourceReference workflow = null, LogicWorkflowRunTrigger trigger = null, IReadOnlyDictionary<string, LogicWorkflowOutputParameterInfo> outputs = null, LogicWorkflowRunTrigger response = null)
        {
            outputs ??= new Dictionary<string, LogicWorkflowOutputParameterInfo>();

            return new LogicWorkflowRunData(
                id,
                name,
                resourceType,
                systemData,
                waitEndOn,
                startOn,
                endOn,
                status,
                code,
                error,
                correlationId,
                correlationClientTrackingId != null ? new Correlation(correlationClientTrackingId, serializedAdditionalRawData: null) : null,
                workflow,
                trigger,
                outputs,
                response,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWorkflowRunTrigger"/>. </summary>
        /// <param name="name"> Gets the name. </param>
        /// <param name="inputs"> Gets the inputs. </param>
        /// <param name="inputsLink"> Gets the link to inputs. </param>
        /// <param name="outputs"> Gets the outputs. </param>
        /// <param name="outputsLink"> Gets the link to outputs. </param>
        /// <param name="scheduledOn"> Gets the scheduled time. </param>
        /// <param name="startOn"> Gets the start time. </param>
        /// <param name="endOn"> Gets the end time. </param>
        /// <param name="trackingId"> Gets the tracking id. </param>
        /// <param name="correlationClientTrackingId"> The run correlation. </param>
        /// <param name="code"> Gets the code. </param>
        /// <param name="status"> Gets the status. </param>
        /// <param name="error"> Gets the error. </param>
        /// <param name="trackedProperties"> Gets the tracked properties. </param>
        /// <returns> A new <see cref="Models.LogicWorkflowRunTrigger"/> instance for mocking. </returns>
        public static LogicWorkflowRunTrigger LogicWorkflowRunTrigger(string name = null, BinaryData inputs = null, LogicContentLink inputsLink = null, BinaryData outputs = null, LogicContentLink outputsLink = null, DateTimeOffset? scheduledOn = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, Guid? trackingId = null, string correlationClientTrackingId = null, string code = null, LogicWorkflowStatus? status = null, BinaryData error = null, BinaryData trackedProperties = null)
        {
            return new LogicWorkflowRunTrigger(
                name,
                inputs,
                inputsLink,
                outputs,
                outputsLink,
                scheduledOn,
                startOn,
                endOn,
                trackingId,
                correlationClientTrackingId != null ? new Correlation(correlationClientTrackingId, serializedAdditionalRawData: null) : null,
                code,
                status,
                error,
                trackedProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWorkflowOutputParameterInfo"/>. </summary>
        /// <param name="parameterType"> The type. </param>
        /// <param name="value"> The value. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <param name="description"> The description. </param>
        /// <param name="error"> Gets the error. </param>
        /// <returns> A new <see cref="Models.LogicWorkflowOutputParameterInfo"/> instance for mocking. </returns>
        public static LogicWorkflowOutputParameterInfo LogicWorkflowOutputParameterInfo(LogicWorkflowParameterType? parameterType = null, BinaryData value = null, BinaryData metadata = null, string description = null, BinaryData error = null)
        {
            return new LogicWorkflowOutputParameterInfo(
                parameterType,
                value,
                metadata,
                description,
                serializedAdditionalRawData: null,
                error);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowRunActionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="startOn"> Gets the start time. </param>
        /// <param name="endOn"> Gets the end time. </param>
        /// <param name="status"> Gets the status. </param>
        /// <param name="code"> Gets the code. </param>
        /// <param name="error"> Gets the error. </param>
        /// <param name="trackingId"> Gets the tracking id. </param>
        /// <param name="correlation"> The correlation properties. </param>
        /// <param name="inputsLink"> Gets the link to inputs. </param>
        /// <param name="outputsLink"> Gets the link to outputs. </param>
        /// <param name="trackedProperties"> Gets the tracked properties. </param>
        /// <param name="retryHistory"> Gets the retry histories. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowRunActionData"/> instance for mocking. </returns>
        public static LogicWorkflowRunActionData LogicWorkflowRunActionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, LogicWorkflowStatus? status = null, string code = null, BinaryData error = null, Guid? trackingId = null, LogicWorkflowRunActionCorrelation correlation = null, LogicContentLink inputsLink = null, LogicContentLink outputsLink = null, BinaryData trackedProperties = null, IEnumerable<LogicWorkRetryHistory> retryHistory = null)
        {
            retryHistory ??= new List<LogicWorkRetryHistory>();

            return new LogicWorkflowRunActionData(
                id,
                name,
                resourceType,
                systemData,
                startOn,
                endOn,
                status,
                code,
                error,
                trackingId,
                correlation,
                inputsLink,
                outputsLink,
                trackedProperties,
                retryHistory?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicExpressionRoot"/>. </summary>
        /// <param name="text"> The text. </param>
        /// <param name="value"> Anything. </param>
        /// <param name="subexpressions"> The sub expressions. </param>
        /// <param name="error"> The azure resource error info. </param>
        /// <param name="path"> The path. </param>
        /// <returns> A new <see cref="Models.LogicExpressionRoot"/> instance for mocking. </returns>
        public static LogicExpressionRoot LogicExpressionRoot(string text = null, BinaryData value = null, IEnumerable<LogicExpression> subexpressions = null, LogicExpressionErrorInfo error = null, string path = null)
        {
            subexpressions ??= new List<LogicExpression>();

            return new LogicExpressionRoot(
                text,
                value,
                subexpressions?.ToList(),
                error,
                serializedAdditionalRawData: null,
                path);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicExpression"/>. </summary>
        /// <param name="text"> The text. </param>
        /// <param name="value"> Anything. </param>
        /// <param name="subexpressions"> The sub expressions. </param>
        /// <param name="error"> The azure resource error info. </param>
        /// <returns> A new <see cref="Models.LogicExpression"/> instance for mocking. </returns>
        public static LogicExpression LogicExpression(string text = null, BinaryData value = null, IEnumerable<LogicExpression> subexpressions = null, LogicExpressionErrorInfo error = null)
        {
            subexpressions ??= new List<LogicExpression>();

            return new LogicExpression(text, value, subexpressions?.ToList(), error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicExpressionErrorInfo"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="details"> The error details. </param>
        /// <returns> A new <see cref="Models.LogicExpressionErrorInfo"/> instance for mocking. </returns>
        public static LogicExpressionErrorInfo LogicExpressionErrorInfo(string code = null, string message = null, IEnumerable<LogicExpressionErrorInfo> details = null)
        {
            details ??= new List<LogicExpressionErrorInfo>();

            return new LogicExpressionErrorInfo(code, serializedAdditionalRawData: null, message, details?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicErrorInfo"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <returns> A new <see cref="Models.LogicErrorInfo"/> instance for mocking. </returns>
        public static LogicErrorInfo LogicErrorInfo(string code = null)
        {
            return new LogicErrorInfo(code, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowRunActionRepetitionDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="startOn"> The start time of the workflow scope repetition. </param>
        /// <param name="endOn"> The end time of the workflow scope repetition. </param>
        /// <param name="correlation"> The correlation properties. </param>
        /// <param name="status"> The status of the workflow scope repetition. </param>
        /// <param name="code"> The workflow scope repetition code. </param>
        /// <param name="error"> Anything. </param>
        /// <param name="trackingId"> Gets the tracking id. </param>
        /// <param name="inputs"> Gets the inputs. </param>
        /// <param name="inputsLink"> Gets the link to inputs. </param>
        /// <param name="outputs"> Gets the outputs. </param>
        /// <param name="outputsLink"> Gets the link to outputs. </param>
        /// <param name="trackedProperties"> Gets the tracked properties. </param>
        /// <param name="retryHistory"> Gets the retry histories. </param>
        /// <param name="iterationCount"></param>
        /// <param name="repetitionIndexes"> The repetition indexes. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowRunActionRepetitionDefinitionData"/> instance for mocking. </returns>
        public static LogicWorkflowRunActionRepetitionDefinitionData LogicWorkflowRunActionRepetitionDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, LogicWorkflowRunActionCorrelation correlation = null, LogicWorkflowStatus? status = null, string code = null, BinaryData error = null, Guid? trackingId = null, BinaryData inputs = null, LogicContentLink inputsLink = null, BinaryData outputs = null, LogicContentLink outputsLink = null, BinaryData trackedProperties = null, IEnumerable<LogicWorkRetryHistory> retryHistory = null, int? iterationCount = null, IEnumerable<LogicWorkflowRepetitionIndex> repetitionIndexes = null)
        {
            tags ??= new Dictionary<string, string>();
            retryHistory ??= new List<LogicWorkRetryHistory>();
            repetitionIndexes ??= new List<LogicWorkflowRepetitionIndex>();

            return new LogicWorkflowRunActionRepetitionDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                startOn,
                endOn,
                correlation,
                status,
                code,
                error,
                trackingId,
                inputs,
                inputsLink,
                outputs,
                outputsLink,
                trackedProperties,
                retryHistory?.ToList(),
                iterationCount,
                repetitionIndexes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.LogicWorkflowRequestHistoryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The request history properties. </param>
        /// <returns> A new <see cref="Logic.LogicWorkflowRequestHistoryData"/> instance for mocking. </returns>
        public static LogicWorkflowRequestHistoryData LogicWorkflowRequestHistoryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, LogicWorkflowRequestHistoryProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new LogicWorkflowRequestHistoryData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="skuName"> The sku. </param>
        /// <param name="integrationServiceEnvironment"> The integration service environment. </param>
        /// <param name="state"> The workflow state. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountData"/> instance for mocking. </returns>
        public static IntegrationAccountData IntegrationAccountData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationAccountSkuName? skuName = null, LogicResourceReference integrationServiceEnvironment = null, LogicWorkflowState? state = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                skuName.HasValue ? new IntegrationAccountSku(skuName.Value, serializedAdditionalRawData: null) : null,
                integrationServiceEnvironment,
                state,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountAssemblyDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The assembly properties. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountAssemblyDefinitionData"/> instance for mocking. </returns>
        public static IntegrationAccountAssemblyDefinitionData IntegrationAccountAssemblyDefinitionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationAccountAssemblyProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountAssemblyDefinitionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountBatchConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The batch configuration properties. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountBatchConfigurationData"/> instance for mocking. </returns>
        public static IntegrationAccountBatchConfigurationData IntegrationAccountBatchConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationAccountBatchConfigurationProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountBatchConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ListOperationCallbackUri"/>. </summary>
        /// <param name="uri"> The URL value. </param>
        /// <returns> A new <see cref="Models.ListOperationCallbackUri"/> instance for mocking. </returns>
        public static ListOperationCallbackUri ListOperationCallbackUri(Uri uri = null)
        {
            return new ListOperationCallbackUri(uri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationAccountListKeyVaultKeyContent"/>. </summary>
        /// <param name="keyVault"> The key vault reference. </param>
        /// <param name="skipToken"> The skip token. </param>
        /// <returns> A new <see cref="Models.IntegrationAccountListKeyVaultKeyContent"/> instance for mocking. </returns>
        public static IntegrationAccountListKeyVaultKeyContent IntegrationAccountListKeyVaultKeyContent(IntegrationAccountKeyVaultNameReference keyVault = null, string skipToken = null)
        {
            return new IntegrationAccountListKeyVaultKeyContent(keyVault, skipToken, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationAccountKeyVaultNameReference"/>. </summary>
        /// <param name="id"> The resource id. </param>
        /// <param name="name"> Gets the resource name. </param>
        /// <param name="resourceType"> Gets the resource type. </param>
        /// <returns> A new <see cref="Models.IntegrationAccountKeyVaultNameReference"/> instance for mocking. </returns>
        public static IntegrationAccountKeyVaultNameReference IntegrationAccountKeyVaultNameReference(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null)
        {
            return new IntegrationAccountKeyVaultNameReference(id, name, resourceType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationAccountKeyVaultKey"/>. </summary>
        /// <param name="keyId"> The key id. </param>
        /// <param name="isEnabled"> Whether the key is enabled or not. </param>
        /// <param name="createdOn"> When the key was created. </param>
        /// <param name="updatedOn"> When the key was updated. </param>
        /// <returns> A new <see cref="Models.IntegrationAccountKeyVaultKey"/> instance for mocking. </returns>
        public static IntegrationAccountKeyVaultKey IntegrationAccountKeyVaultKey(Uri keyId = null, bool? isEnabled = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null)
        {
            return new IntegrationAccountKeyVaultKey(keyId, isEnabled, createdOn, updatedOn, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationAccountTrackingEventsContent"/>. </summary>
        /// <param name="sourceType"> The source type. </param>
        /// <param name="trackEventsOptions"> The track events options. </param>
        /// <param name="events"> The events. </param>
        /// <returns> A new <see cref="Models.IntegrationAccountTrackingEventsContent"/> instance for mocking. </returns>
        public static IntegrationAccountTrackingEventsContent IntegrationAccountTrackingEventsContent(string sourceType = null, IntegrationAccountTrackEventOperationOption? trackEventsOptions = null, IEnumerable<IntegrationAccountTrackingEvent> events = null)
        {
            events ??= new List<IntegrationAccountTrackingEvent>();

            return new IntegrationAccountTrackingEventsContent(sourceType, trackEventsOptions, events?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationAccountTrackingEvent"/>. </summary>
        /// <param name="eventLevel"> The event level. </param>
        /// <param name="eventOn"> The event time. </param>
        /// <param name="recordType"> The record type. </param>
        /// <param name="record"> The record. </param>
        /// <param name="error"> The error. </param>
        /// <returns> A new <see cref="Models.IntegrationAccountTrackingEvent"/> instance for mocking. </returns>
        public static IntegrationAccountTrackingEvent IntegrationAccountTrackingEvent(IntegrationAccountEventLevel eventLevel = default, DateTimeOffset eventOn = default, IntegrationAccountTrackingRecordType recordType = default, BinaryData record = null, IntegrationAccountTrackingEventErrorInfo error = null)
        {
            return new IntegrationAccountTrackingEvent(
                eventLevel,
                eventOn,
                recordType,
                record,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountSchemaData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="schemaType"> The schema type. </param>
        /// <param name="targetNamespace"> The target namespace of the schema. </param>
        /// <param name="documentName"> The document name. </param>
        /// <param name="fileName"> The file name. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="changedOn"> The changed time. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <param name="content"> The content. </param>
        /// <param name="contentType"> The content type. </param>
        /// <param name="contentLink"> The content link. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountSchemaData"/> instance for mocking. </returns>
        public static IntegrationAccountSchemaData IntegrationAccountSchemaData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationAccountSchemaType schemaType = default, string targetNamespace = null, string documentName = null, string fileName = null, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, BinaryData metadata = null, BinaryData content = null, ContentType? contentType = null, LogicContentLink contentLink = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountSchemaData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                schemaType,
                targetNamespace,
                documentName,
                fileName,
                createdOn,
                changedOn,
                metadata,
                content,
                contentType,
                contentLink,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountMapData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="mapType"> The map type. </param>
        /// <param name="parametersSchemaRef"> The parameters schema of integration account map. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="changedOn"> The changed time. </param>
        /// <param name="content"> The content. </param>
        /// <param name="contentType"> The content type. </param>
        /// <param name="contentLink"> The content link. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountMapData"/> instance for mocking. </returns>
        public static IntegrationAccountMapData IntegrationAccountMapData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationAccountMapType mapType = default, string parametersSchemaRef = null, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, BinaryData content = null, ContentType? contentType = null, LogicContentLink contentLink = null, BinaryData metadata = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountMapData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                mapType,
                parametersSchemaRef != null ? new IntegrationAccountMapPropertiesParametersSchema(parametersSchemaRef, serializedAdditionalRawData: null) : null,
                createdOn,
                changedOn,
                content,
                contentType,
                contentLink,
                metadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountPartnerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="partnerType"> The partner type. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="changedOn"> The changed time. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <param name="b2bBusinessIdentities"> The partner content. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountPartnerData"/> instance for mocking. </returns>
        public static IntegrationAccountPartnerData IntegrationAccountPartnerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationAccountPartnerType partnerType = default, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, BinaryData metadata = null, IEnumerable<IntegrationAccountBusinessIdentity> b2bBusinessIdentities = null)
        {
            tags ??= new Dictionary<string, string>();
            b2bBusinessIdentities ??= new List<IntegrationAccountBusinessIdentity>();

            return new IntegrationAccountPartnerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                partnerType,
                createdOn,
                changedOn,
                metadata,
                b2bBusinessIdentities != null ? new IntegrationAccountPartnerContent(new B2BPartnerContent(b2bBusinessIdentities?.ToList(), serializedAdditionalRawData: null), serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountAgreementData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="changedOn"> The changed time. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <param name="agreementType"> The agreement type. </param>
        /// <param name="hostPartner"> The integration account partner that is set as host partner for this agreement. </param>
        /// <param name="guestPartner"> The integration account partner that is set as guest partner for this agreement. </param>
        /// <param name="hostIdentity"> The business identity of the host partner. </param>
        /// <param name="guestIdentity"> The business identity of the guest partner. </param>
        /// <param name="content"> The agreement content. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountAgreementData"/> instance for mocking. </returns>
        public static IntegrationAccountAgreementData IntegrationAccountAgreementData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, BinaryData metadata = null, IntegrationAccountAgreementType agreementType = default, string hostPartner = null, string guestPartner = null, IntegrationAccountBusinessIdentity hostIdentity = null, IntegrationAccountBusinessIdentity guestIdentity = null, IntegrationAccountAgreementContent content = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountAgreementData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                createdOn,
                changedOn,
                metadata,
                agreementType,
                hostPartner,
                guestPartner,
                hostIdentity,
                guestIdentity,
                content,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="changedOn"> The changed time. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <param name="key"> The key details in the key vault. </param>
        /// <param name="publicCertificate"> The public certificate. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountCertificateData"/> instance for mocking. </returns>
        public static IntegrationAccountCertificateData IntegrationAccountCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, BinaryData metadata = null, IntegrationAccountKeyVaultKeyReference key = null, BinaryData publicCertificate = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountCertificateData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                createdOn,
                changedOn,
                metadata,
                key,
                publicCertificate,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationAccountKeyVaultKeyReference"/>. </summary>
        /// <param name="keyName"> The private key name in key vault. </param>
        /// <param name="keyVersion"> The private key version in key vault. </param>
        /// <param name="resourceId"> The resource id. </param>
        /// <param name="resourceName"> The resource name. </param>
        /// <param name="resourceType"> The resource type. </param>
        /// <returns> A new <see cref="Models.IntegrationAccountKeyVaultKeyReference"/> instance for mocking. </returns>
        public static IntegrationAccountKeyVaultKeyReference IntegrationAccountKeyVaultKeyReference(string keyName = null, string keyVersion = null, ResourceIdentifier resourceId = null, string resourceName = null, ResourceType? resourceType = null)
        {
            return new IntegrationAccountKeyVaultKeyReference(
                keyName,
                keyVersion,
                resourceId,
                resourceName,
                resourceType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationAccountSessionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="changedOn"> The changed time. </param>
        /// <param name="content"> The session content. </param>
        /// <returns> A new <see cref="Logic.IntegrationAccountSessionData"/> instance for mocking. </returns>
        public static IntegrationAccountSessionData IntegrationAccountSessionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DateTimeOffset? createdOn = null, DateTimeOffset? changedOn = null, BinaryData content = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationAccountSessionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                createdOn,
                changedOn,
                content,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationServiceEnvironmentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The integration service environment properties. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="identity"> Managed service identity properties. Current supported identity types: SystemAssigned, UserAssigned, None. </param>
        /// <returns> A new <see cref="Logic.IntegrationServiceEnvironmentData"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentData IntegrationServiceEnvironmentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IntegrationServiceEnvironmentProperties properties = null, IntegrationServiceEnvironmentSku sku = null, ManagedServiceIdentity identity = null)
        {
            tags ??= new Dictionary<string, string>();

            return new IntegrationServiceEnvironmentData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                sku,
                identity,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentSkuDefinition"/>. </summary>
        /// <param name="resourceType"> The resource type. </param>
        /// <param name="sku"> The sku. </param>
        /// <param name="capacity"> The sku capacity. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentSkuDefinition"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentSkuDefinition IntegrationServiceEnvironmentSkuDefinition(ResourceType? resourceType = null, IntegrationServiceEnvironmentSkuDefinitionSku sku = null, IntegrationServiceEnvironmentSkuCapacity capacity = null)
        {
            return new IntegrationServiceEnvironmentSkuDefinition(resourceType, sku, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentSkuDefinitionSku"/>. </summary>
        /// <param name="name"> The sku name. </param>
        /// <param name="tier"> The sku tier. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentSkuDefinitionSku"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentSkuDefinitionSku IntegrationServiceEnvironmentSkuDefinitionSku(IntegrationServiceEnvironmentSkuName? name = null, string tier = null)
        {
            return new IntegrationServiceEnvironmentSkuDefinitionSku(name, tier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentSkuCapacity"/>. </summary>
        /// <param name="minimum"> The minimum capacity. </param>
        /// <param name="maximum"> The maximum capacity. </param>
        /// <param name="default"> The default capacity. </param>
        /// <param name="scaleType"> The sku scale type. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentSkuCapacity"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentSkuCapacity IntegrationServiceEnvironmentSkuCapacity(int? minimum = null, int? maximum = null, int? @default = null, IntegrationServiceEnvironmentSkuScaleType? scaleType = null)
        {
            return new IntegrationServiceEnvironmentSkuCapacity(minimum, maximum, @default, scaleType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentSubnetNetworkHealth"/>. </summary>
        /// <param name="outboundNetworkDependencies"> The outbound network dependencies. </param>
        /// <param name="outboundNetworkHealth"> The integration service environment network health. </param>
        /// <param name="networkDependencyHealthState"> The integration service environment network health state. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentSubnetNetworkHealth"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentSubnetNetworkHealth IntegrationServiceEnvironmentSubnetNetworkHealth(IEnumerable<IntegrationServiceEnvironmentNetworkDependency> outboundNetworkDependencies = null, IntegrationServiceEnvironmentNetworkDependencyHealth outboundNetworkHealth = null, IntegrationServiceEnvironmentNetworkEndPointAccessibilityState networkDependencyHealthState = default)
        {
            outboundNetworkDependencies ??= new List<IntegrationServiceEnvironmentNetworkDependency>();

            return new IntegrationServiceEnvironmentSubnetNetworkHealth(outboundNetworkDependencies?.ToList(), outboundNetworkHealth, networkDependencyHealthState, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentNetworkDependency"/>. </summary>
        /// <param name="category"> The network dependency category type. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="endpoints"> The endpoints. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentNetworkDependency"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentNetworkDependency IntegrationServiceEnvironmentNetworkDependency(IntegrationServiceEnvironmentNetworkDependencyCategoryType? category = null, string displayName = null, IEnumerable<IntegrationServiceEnvironmentNetworkEndpoint> endpoints = null)
        {
            endpoints ??= new List<IntegrationServiceEnvironmentNetworkEndpoint>();

            return new IntegrationServiceEnvironmentNetworkDependency(category, displayName, endpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentNetworkEndpoint"/>. </summary>
        /// <param name="accessibility"> The accessibility state. </param>
        /// <param name="domainName"> The domain name. </param>
        /// <param name="ports"> The ports. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentNetworkEndpoint"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentNetworkEndpoint IntegrationServiceEnvironmentNetworkEndpoint(IntegrationServiceEnvironmentNetworkEndPointAccessibilityState? accessibility = null, string domainName = null, IEnumerable<string> ports = null)
        {
            ports ??= new List<string>();

            return new IntegrationServiceEnvironmentNetworkEndpoint(accessibility, domainName, ports?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceEnvironmentNetworkDependencyHealth"/>. </summary>
        /// <param name="error"> The error if any occurred during the operation. </param>
        /// <param name="state"> The network dependency health state. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceEnvironmentNetworkDependencyHealth"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentNetworkDependencyHealth IntegrationServiceEnvironmentNetworkDependencyHealth(IntegrationServiceErrorInfo error = null, IntegrationServiceEnvironmentNetworkDependencyHealthState? state = null)
        {
            return new IntegrationServiceEnvironmentNetworkDependencyHealth(error, state, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationServiceErrorInfo"/>. </summary>
        /// <param name="code"> The error code. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="details"> The error message details. </param>
        /// <param name="innerError"> The inner error. </param>
        /// <returns> A new <see cref="Models.IntegrationServiceErrorInfo"/> instance for mocking. </returns>
        public static IntegrationServiceErrorInfo IntegrationServiceErrorInfo(IntegrationServiceErrorCode code = default, string message = null, IEnumerable<IntegrationServiceErrorInfo> details = null, BinaryData innerError = null)
        {
            details ??= new List<IntegrationServiceErrorInfo>();

            return new IntegrationServiceErrorInfo(code, message, details?.ToList(), innerError, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Logic.IntegrationServiceEnvironmentManagedApiData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="namePropertiesName"> The name. </param>
        /// <param name="connectionParameters"> The connection parameters. </param>
        /// <param name="metadata"> The metadata. </param>
        /// <param name="runtimeUris"> The runtime urls. </param>
        /// <param name="generalInformation"> The api general information. </param>
        /// <param name="capabilities"> The capabilities. </param>
        /// <param name="serviceUri"> The backend service. </param>
        /// <param name="policies"> The policies for the API. </param>
        /// <param name="apiDefinitionUri"> The API definition. </param>
        /// <param name="apiDefinitions"> The api definitions. </param>
        /// <param name="integrationServiceEnvironment"> The integration service environment reference. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="category"> The category. </param>
        /// <param name="deploymentParametersContentLinkDefinition"> The integration service environment managed api deployment parameters. </param>
        /// <returns> A new <see cref="Logic.IntegrationServiceEnvironmentManagedApiData"/> instance for mocking. </returns>
        public static IntegrationServiceEnvironmentManagedApiData IntegrationServiceEnvironmentManagedApiData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string namePropertiesName = null, IReadOnlyDictionary<string, BinaryData> connectionParameters = null, LogicApiResourceMetadata metadata = null, IEnumerable<Uri> runtimeUris = null, LogicApiResourceGeneralInformation generalInformation = null, IEnumerable<string> capabilities = null, Uri serviceUri = null, LogicApiResourcePolicies policies = null, Uri apiDefinitionUri = null, LogicApiResourceDefinitions apiDefinitions = null, LogicResourceReference integrationServiceEnvironment = null, LogicWorkflowProvisioningState? provisioningState = null, LogicApiTier? category = null, LogicContentLink deploymentParametersContentLinkDefinition = null)
        {
            tags ??= new Dictionary<string, string>();
            connectionParameters ??= new Dictionary<string, BinaryData>();
            runtimeUris ??= new List<Uri>();
            capabilities ??= new List<string>();

            return new IntegrationServiceEnvironmentManagedApiData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                namePropertiesName,
                connectionParameters,
                metadata,
                runtimeUris?.ToList(),
                generalInformation,
                capabilities?.ToList(),
                serviceUri != null ? new LogicApiResourceBackendService(serviceUri, serializedAdditionalRawData: null) : null,
                policies,
                apiDefinitionUri,
                apiDefinitions,
                integrationServiceEnvironment,
                provisioningState,
                category,
                deploymentParametersContentLinkDefinition != null ? new IntegrationServiceEnvironmentManagedApiDeploymentParameters(deploymentParametersContentLinkDefinition, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiResourceMetadata"/>. </summary>
        /// <param name="source"> The source. </param>
        /// <param name="brandColor"> The brand color. </param>
        /// <param name="hideKey"> The hide key. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="apiType"> The api type. </param>
        /// <param name="wsdlService"> The WSDL service. </param>
        /// <param name="wsdlImportMethod"> The WSDL import method. </param>
        /// <param name="connectionType"> The connection type. </param>
        /// <param name="provisioningState"> The provisioning state. </param>
        /// <param name="deploymentParameters"> The connector deployment parameters metadata. </param>
        /// <returns> A new <see cref="Models.LogicApiResourceMetadata"/> instance for mocking. </returns>
        public static LogicApiResourceMetadata LogicApiResourceMetadata(string source = null, string brandColor = null, string hideKey = null, IReadOnlyDictionary<string, string> tags = null, LogicApiType? apiType = null, LogicWsdlService wsdlService = null, LogicWsdlImportMethod? wsdlImportMethod = null, string connectionType = null, LogicWorkflowProvisioningState? provisioningState = null, LogicApiDeploymentParameterMetadataSet deploymentParameters = null)
        {
            tags ??= new Dictionary<string, string>();

            return new LogicApiResourceMetadata(
                source,
                brandColor,
                hideKey,
                tags,
                apiType,
                wsdlService,
                wsdlImportMethod,
                connectionType,
                provisioningState,
                deploymentParameters,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicWsdlService"/>. </summary>
        /// <param name="qualifiedName"> The qualified name. </param>
        /// <param name="endpointQualifiedNames"> The list of endpoints' qualified names. </param>
        /// <returns> A new <see cref="Models.LogicWsdlService"/> instance for mocking. </returns>
        public static LogicWsdlService LogicWsdlService(string qualifiedName = null, IEnumerable<string> endpointQualifiedNames = null)
        {
            endpointQualifiedNames ??= new List<string>();

            return new LogicWsdlService(qualifiedName, endpointQualifiedNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiDeploymentParameterMetadataSet"/>. </summary>
        /// <param name="packageContentLink"> The package content link parameter. </param>
        /// <param name="redisCacheConnectionString"> The package content link parameter. </param>
        /// <returns> A new <see cref="Models.LogicApiDeploymentParameterMetadataSet"/> instance for mocking. </returns>
        public static LogicApiDeploymentParameterMetadataSet LogicApiDeploymentParameterMetadataSet(LogicApiDeploymentParameterMetadata packageContentLink = null, LogicApiDeploymentParameterMetadata redisCacheConnectionString = null)
        {
            return new LogicApiDeploymentParameterMetadataSet(packageContentLink, redisCacheConnectionString, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiDeploymentParameterMetadata"/>. </summary>
        /// <param name="apiDeploymentParameterMetadataType"> The type. </param>
        /// <param name="isRequired"> Indicates whether its required. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="description"> The description. </param>
        /// <param name="visibility"> The visibility. </param>
        /// <returns> A new <see cref="Models.LogicApiDeploymentParameterMetadata"/> instance for mocking. </returns>
        public static LogicApiDeploymentParameterMetadata LogicApiDeploymentParameterMetadata(string apiDeploymentParameterMetadataType = null, bool? isRequired = null, string displayName = null, string description = null, LogicApiDeploymentParameterVisibility? visibility = null)
        {
            return new LogicApiDeploymentParameterMetadata(
                apiDeploymentParameterMetadataType,
                isRequired,
                displayName,
                description,
                visibility,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiResourceGeneralInformation"/>. </summary>
        /// <param name="iconUri"> The icon url. </param>
        /// <param name="displayName"> The display name. </param>
        /// <param name="description"> The description. </param>
        /// <param name="termsOfUseUri"> The terms of use url. </param>
        /// <param name="releaseTag"> The release tag. </param>
        /// <param name="tier"> The tier. </param>
        /// <returns> A new <see cref="Models.LogicApiResourceGeneralInformation"/> instance for mocking. </returns>
        public static LogicApiResourceGeneralInformation LogicApiResourceGeneralInformation(Uri iconUri = null, string displayName = null, string description = null, Uri termsOfUseUri = null, string releaseTag = null, LogicApiTier? tier = null)
        {
            return new LogicApiResourceGeneralInformation(
                iconUri,
                displayName,
                description,
                termsOfUseUri,
                releaseTag,
                tier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiResourcePolicies"/>. </summary>
        /// <param name="content"> The API level only policies XML as embedded content. </param>
        /// <param name="contentLink"> The content link to the policies. </param>
        /// <returns> A new <see cref="Models.LogicApiResourcePolicies"/> instance for mocking. </returns>
        public static LogicApiResourcePolicies LogicApiResourcePolicies(BinaryData content = null, string contentLink = null)
        {
            return new LogicApiResourcePolicies(content, contentLink, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiResourceDefinitions"/>. </summary>
        /// <param name="originalSwaggerUri"> The original swagger url. </param>
        /// <param name="modifiedSwaggerUri"> The modified swagger url. </param>
        /// <returns> A new <see cref="Models.LogicApiResourceDefinitions"/> instance for mocking. </returns>
        public static LogicApiResourceDefinitions LogicApiResourceDefinitions(Uri originalSwaggerUri = null, Uri modifiedSwaggerUri = null)
        {
            return new LogicApiResourceDefinitions(originalSwaggerUri, modifiedSwaggerUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiOperationInfo"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> The api operations properties. </param>
        /// <returns> A new <see cref="Models.LogicApiOperationInfo"/> instance for mocking. </returns>
        public static LogicApiOperationInfo LogicApiOperationInfo(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, LogicApiOperationProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new LogicApiOperationInfo(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogicApiReference"/>. </summary>
        /// <param name="id"> The resource id. </param>
        /// <param name="name"> Gets the resource name. </param>
        /// <param name="resourceType"> Gets the resource type. </param>
        /// <param name="displayName"> The display name of the api. </param>
        /// <param name="description"> The description of the api. </param>
        /// <param name="iconUri"> The icon uri of the api. </param>
        /// <param name="swagger"> The swagger of the api. </param>
        /// <param name="brandColor"> The brand color of the api. </param>
        /// <param name="category"> The tier. </param>
        /// <param name="integrationServiceEnvironment"> The integration service environment reference. </param>
        /// <returns> A new <see cref="Models.LogicApiReference"/> instance for mocking. </returns>
        public static LogicApiReference LogicApiReference(ResourceIdentifier id = null, string name = null, ResourceType? resourceType = null, string displayName = null, string description = null, Uri iconUri = null, BinaryData swagger = null, string brandColor = null, LogicApiTier? category = null, LogicResourceReference integrationServiceEnvironment = null)
        {
            return new LogicApiReference(
                id,
                name,
                resourceType,
                serializedAdditionalRawData: null,
                displayName,
                description,
                iconUri,
                swagger,
                brandColor,
                category,
                integrationServiceEnvironment);
        }
    }
}
