// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Logic.Samples
{
    public partial class Sample_LogicWorkflowTriggerHistoryResource
    {
        // Get a workflow trigger history
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAWorkflowTriggerHistory()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/WorkflowTriggerHistories_Get.json
            // this example is just showing the usage of "WorkflowTriggerHistories_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LogicWorkflowTriggerHistoryResource created on azure
            // for more information of creating LogicWorkflowTriggerHistoryResource, please refer to the document of LogicWorkflowTriggerHistoryResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string workflowName = "testWorkflowName";
            string triggerName = "testTriggerName";
            string historyName = "08586676746934337772206998657CU22";
            ResourceIdentifier logicWorkflowTriggerHistoryResourceId = LogicWorkflowTriggerHistoryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workflowName, triggerName, historyName);
            LogicWorkflowTriggerHistoryResource logicWorkflowTriggerHistory = client.GetLogicWorkflowTriggerHistoryResource(logicWorkflowTriggerHistoryResourceId);

            // invoke the operation
            LogicWorkflowTriggerHistoryResource result = await logicWorkflowTriggerHistory.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LogicWorkflowTriggerHistoryData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Resubmit a workflow run based on the trigger history
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Resubmit_ResubmitAWorkflowRunBasedOnTheTriggerHistory()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/WorkflowTriggerHistories_Resubmit.json
            // this example is just showing the usage of "WorkflowTriggerHistories_Resubmit" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LogicWorkflowTriggerHistoryResource created on azure
            // for more information of creating LogicWorkflowTriggerHistoryResource, please refer to the document of LogicWorkflowTriggerHistoryResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string workflowName = "testWorkflowName";
            string triggerName = "testTriggerName";
            string historyName = "testHistoryName";
            ResourceIdentifier logicWorkflowTriggerHistoryResourceId = LogicWorkflowTriggerHistoryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workflowName, triggerName, historyName);
            LogicWorkflowTriggerHistoryResource logicWorkflowTriggerHistory = client.GetLogicWorkflowTriggerHistoryResource(logicWorkflowTriggerHistoryResourceId);

            // invoke the operation
            await logicWorkflowTriggerHistory.ResubmitAsync();

            Console.WriteLine($"Succeeded");
        }
    }
}
