// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Logic.Samples
{
    public partial class Sample_LogicWorkflowRunActionRequestHistoryResource
    {
        // Get a request history
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetARequestHistory()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/WorkflowRunActionRequestHistories_Get.json
            // this example is just showing the usage of "WorkflowRunActionRequestHistories_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LogicWorkflowRunActionRequestHistoryResource created on azure
            // for more information of creating LogicWorkflowRunActionRequestHistoryResource, please refer to the document of LogicWorkflowRunActionRequestHistoryResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "test-resource-group";
            string workflowName = "test-workflow";
            string runName = "08586776228332053161046300351";
            string actionName = "HTTP_Webhook";
            string requestHistoryName = "08586611142732800686";
            ResourceIdentifier logicWorkflowRunActionRequestHistoryResourceId = LogicWorkflowRunActionRequestHistoryResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, workflowName, runName, actionName, requestHistoryName);
            LogicWorkflowRunActionRequestHistoryResource logicWorkflowRunActionRequestHistory = client.GetLogicWorkflowRunActionRequestHistoryResource(logicWorkflowRunActionRequestHistoryResourceId);

            // invoke the operation
            LogicWorkflowRunActionRequestHistoryResource result = await logicWorkflowRunActionRequestHistory.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LogicWorkflowRequestHistoryData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
