// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Logic.Models;

namespace Azure.ResourceManager.Logic.Samples
{
    public partial class Sample_IntegrationAccountBatchConfigurationResource
    {
        // Get a batch configuration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetABatchConfiguration()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountBatchConfigurations_Get.json
            // this example is just showing the usage of "IntegrationAccountBatchConfigurations_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountBatchConfigurationResource created on azure
            // for more information of creating IntegrationAccountBatchConfigurationResource, please refer to the document of IntegrationAccountBatchConfigurationResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string batchConfigurationName = "testBatchConfiguration";
            ResourceIdentifier integrationAccountBatchConfigurationResourceId = IntegrationAccountBatchConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, batchConfigurationName);
            IntegrationAccountBatchConfigurationResource integrationAccountBatchConfiguration = client.GetIntegrationAccountBatchConfigurationResource(integrationAccountBatchConfigurationResourceId);

            // invoke the operation
            IntegrationAccountBatchConfigurationResource result = await integrationAccountBatchConfiguration.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            IntegrationAccountBatchConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update a batch configuration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateABatchConfiguration()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountBatchConfigurations_CreateOrUpdate.json
            // this example is just showing the usage of "IntegrationAccountBatchConfigurations_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountBatchConfigurationResource created on azure
            // for more information of creating IntegrationAccountBatchConfigurationResource, please refer to the document of IntegrationAccountBatchConfigurationResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string batchConfigurationName = "testBatchConfiguration";
            ResourceIdentifier integrationAccountBatchConfigurationResourceId = IntegrationAccountBatchConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, batchConfigurationName);
            IntegrationAccountBatchConfigurationResource integrationAccountBatchConfiguration = client.GetIntegrationAccountBatchConfigurationResource(integrationAccountBatchConfigurationResourceId);

            // invoke the operation
            IntegrationAccountBatchConfigurationData data = new IntegrationAccountBatchConfigurationData(new AzureLocation("westus"), new IntegrationAccountBatchConfigurationProperties("DEFAULT", new IntegrationAccountBatchReleaseCriteria()
            {
                MessageCount = 10,
                BatchSize = 234567,
                Recurrence = new LogicWorkflowTriggerRecurrence()
                {
                    Frequency = LogicWorkflowRecurrenceFrequency.Minute,
                    Interval = 1,
                    StartOn = DateTimeOffset.Parse("2017-03-24T11:43:00"),
                    TimeZone = "India Standard Time",
                },
            }));
            ArmOperation<IntegrationAccountBatchConfigurationResource> lro = await integrationAccountBatchConfiguration.UpdateAsync(WaitUntil.Completed, data);
            IntegrationAccountBatchConfigurationResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            IntegrationAccountBatchConfigurationData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete a batch configuration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteABatchConfiguration()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountBatchConfigurations_Delete.json
            // this example is just showing the usage of "IntegrationAccountBatchConfigurations_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountBatchConfigurationResource created on azure
            // for more information of creating IntegrationAccountBatchConfigurationResource, please refer to the document of IntegrationAccountBatchConfigurationResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string batchConfigurationName = "testBatchConfiguration";
            ResourceIdentifier integrationAccountBatchConfigurationResourceId = IntegrationAccountBatchConfigurationResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, batchConfigurationName);
            IntegrationAccountBatchConfigurationResource integrationAccountBatchConfiguration = client.GetIntegrationAccountBatchConfigurationResource(integrationAccountBatchConfigurationResourceId);

            // invoke the operation
            await integrationAccountBatchConfiguration.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
