// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Logic.Models;

namespace Azure.ResourceManager.Logic.Samples
{
    public partial class Sample_IntegrationAccountAgreementResource
    {
        // Get agreement by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAgreementByName()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_Get.json
            // this example is just showing the usage of "IntegrationAccountAgreements_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountAgreementResource created on azure
            // for more information of creating IntegrationAccountAgreementResource, please refer to the document of IntegrationAccountAgreementResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string agreementName = "testAgreement";
            ResourceIdentifier integrationAccountAgreementResourceId = IntegrationAccountAgreementResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, agreementName);
            IntegrationAccountAgreementResource integrationAccountAgreement = client.GetIntegrationAccountAgreementResource(integrationAccountAgreementResourceId);

            // invoke the operation
            IntegrationAccountAgreementResource result = await integrationAccountAgreement.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            IntegrationAccountAgreementData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update an agreement
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAnAgreement()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_CreateOrUpdate.json
            // this example is just showing the usage of "IntegrationAccountAgreements_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountAgreementResource created on azure
            // for more information of creating IntegrationAccountAgreementResource, please refer to the document of IntegrationAccountAgreementResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string agreementName = "testAgreement";
            ResourceIdentifier integrationAccountAgreementResourceId = IntegrationAccountAgreementResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, agreementName);
            IntegrationAccountAgreementResource integrationAccountAgreement = client.GetIntegrationAccountAgreementResource(integrationAccountAgreementResourceId);

            // invoke the operation
            IntegrationAccountAgreementData data = new IntegrationAccountAgreementData(new AzureLocation("westus"), IntegrationAccountAgreementType.AS2, "HostPartner", "GuestPartner", new IntegrationAccountBusinessIdentity("ZZ", "ZZ"), new IntegrationAccountBusinessIdentity("AA", "AA"), new IntegrationAccountAgreementContent()
            {
                AS2 = new AS2AgreementContent(new AS2OneWayAgreement(new IntegrationAccountBusinessIdentity("AA", "AA"), new IntegrationAccountBusinessIdentity("ZZ", "ZZ"), new AS2ProtocolSettings(new AS2MessageConnectionSettings(true, true, true, true), new AS2AcknowledgementConnectionSettings(true, true, true, true), new AS2MdnSettings(true, true, true, true, true, AS2HashingAlgorithm.Sha1)
                {
                    ReceiptDeliveryUri = new Uri("http://tempuri.org"),
                    DispositionNotificationTo = "http://tempuri.org",
                    MdnText = "Sample",
                }, new AS2SecuritySettings(false, true, true, true, true, true, true), new AS2ValidationSettings(true, false, false, true, true, 100, true, true, AS2EncryptionAlgorithm.Aes128), new AS2EnvelopeSettings(new ContentType("text/plain"), true, "Test", true, true), new AS2ErrorSettings(true, true))), new AS2OneWayAgreement(new IntegrationAccountBusinessIdentity("ZZ", "ZZ"), new IntegrationAccountBusinessIdentity("AA", "AA"), new AS2ProtocolSettings(new AS2MessageConnectionSettings(true, true, true, true), new AS2AcknowledgementConnectionSettings(true, true, true, true), new AS2MdnSettings(true, true, true, true, true, AS2HashingAlgorithm.Sha1)
                {
                    ReceiptDeliveryUri = new Uri("http://tempuri.org"),
                    DispositionNotificationTo = "http://tempuri.org",
                    MdnText = "Sample",
                }, new AS2SecuritySettings(false, true, true, true, true, true, true), new AS2ValidationSettings(true, false, false, true, true, 100, true, true, AS2EncryptionAlgorithm.Aes128), new AS2EnvelopeSettings(new ContentType("text/plain"), true, "Test", true, true), new AS2ErrorSettings(true, true)))),
            })
            {
                Metadata = BinaryData.FromObjectAsJson(new Dictionary<string, object>()
                {
                }),
                Tags =
{
["IntegrationAccountAgreement"] = "<IntegrationAccountAgreementName>",
},
            };
            ArmOperation<IntegrationAccountAgreementResource> lro = await integrationAccountAgreement.UpdateAsync(WaitUntil.Completed, data);
            IntegrationAccountAgreementResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            IntegrationAccountAgreementData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete an agreement
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAnAgreement()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_Delete.json
            // this example is just showing the usage of "IntegrationAccountAgreements_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountAgreementResource created on azure
            // for more information of creating IntegrationAccountAgreementResource, please refer to the document of IntegrationAccountAgreementResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string agreementName = "testAgreement";
            ResourceIdentifier integrationAccountAgreementResourceId = IntegrationAccountAgreementResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, agreementName);
            IntegrationAccountAgreementResource integrationAccountAgreement = client.GetIntegrationAccountAgreementResource(integrationAccountAgreementResourceId);

            // invoke the operation
            await integrationAccountAgreement.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get the content callback url
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetContentCallbackUrl_GetTheContentCallbackUrl()
        {
            // Generated from example definition: specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountAgreements_ListContentCallbackUrl.json
            // this example is just showing the usage of "IntegrationAccountAgreements_ListContentCallbackUrl" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this IntegrationAccountAgreementResource created on azure
            // for more information of creating IntegrationAccountAgreementResource, please refer to the document of IntegrationAccountAgreementResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "testResourceGroup";
            string integrationAccountName = "testIntegrationAccount";
            string agreementName = "testAgreement";
            ResourceIdentifier integrationAccountAgreementResourceId = IntegrationAccountAgreementResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, integrationAccountName, agreementName);
            IntegrationAccountAgreementResource integrationAccountAgreement = client.GetIntegrationAccountAgreementResource(integrationAccountAgreementResourceId);

            // invoke the operation
            ListOperationCallbackUrlParameterInfo info = new ListOperationCallbackUrlParameterInfo()
            {
                NotAfter = DateTimeOffset.Parse("2018-04-19T16:00:00Z"),
                KeyType = LogicKeyType.Primary,
            };
            LogicWorkflowTriggerCallbackUri result = await integrationAccountAgreement.GetContentCallbackUrlAsync(info);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
