// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LoadTesting.Models
{
    /// <summary> Request object of new quota for a quota bucket. </summary>
    public partial class LoadTestingQuotaBucketContent : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LoadTestingQuotaBucketContent"/>. </summary>
        public LoadTestingQuotaBucketContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LoadTestingQuotaBucketContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="currentUsage"> Current quota usage of the quota bucket. </param>
        /// <param name="currentQuota"> Current quota limit of the quota bucket. </param>
        /// <param name="newQuota"> New quota limit of the quota bucket. </param>
        /// <param name="dimensions"> Dimensions for new quota request. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LoadTestingQuotaBucketContent(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, int? currentUsage, int? currentQuota, int? newQuota, LoadTestingQuotaBucketDimensions dimensions, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            CurrentUsage = currentUsage;
            CurrentQuota = currentQuota;
            NewQuota = newQuota;
            Dimensions = dimensions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current quota usage of the quota bucket. </summary>
        public int? CurrentUsage { get; set; }
        /// <summary> Current quota limit of the quota bucket. </summary>
        public int? CurrentQuota { get; set; }
        /// <summary> New quota limit of the quota bucket. </summary>
        public int? NewQuota { get; set; }
        /// <summary> Dimensions for new quota request. </summary>
        public LoadTestingQuotaBucketDimensions Dimensions { get; set; }
    }
}
