// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LoadTesting.Models
{
    /// <summary> Resources provisioning states. </summary>
    public readonly partial struct LoadTestingProvisioningState : IEquatable<LoadTestingProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LoadTestingProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LoadTestingProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeletedValue = "Deleted";

        /// <summary> Succeeded. </summary>
        public static LoadTestingProvisioningState Succeeded { get; } = new LoadTestingProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static LoadTestingProvisioningState Failed { get; } = new LoadTestingProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static LoadTestingProvisioningState Canceled { get; } = new LoadTestingProvisioningState(CanceledValue);
        /// <summary> Deleted. </summary>
        public static LoadTestingProvisioningState Deleted { get; } = new LoadTestingProvisioningState(DeletedValue);
        /// <summary> Determines if two <see cref="LoadTestingProvisioningState"/> values are the same. </summary>
        public static bool operator ==(LoadTestingProvisioningState left, LoadTestingProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LoadTestingProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(LoadTestingProvisioningState left, LoadTestingProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LoadTestingProvisioningState"/>. </summary>
        public static implicit operator LoadTestingProvisioningState(string value) => new LoadTestingProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LoadTestingProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LoadTestingProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
