// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LoadTesting.Models
{
    /// <summary> Managed identity type to use for accessing encryption key Url. </summary>
    public readonly partial struct LoadTestingCmkIdentityType : IEquatable<LoadTestingCmkIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LoadTestingCmkIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LoadTestingCmkIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary> SystemAssigned. </summary>
        public static LoadTestingCmkIdentityType SystemAssigned { get; } = new LoadTestingCmkIdentityType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static LoadTestingCmkIdentityType UserAssigned { get; } = new LoadTestingCmkIdentityType(UserAssignedValue);
        /// <summary> Determines if two <see cref="LoadTestingCmkIdentityType"/> values are the same. </summary>
        public static bool operator ==(LoadTestingCmkIdentityType left, LoadTestingCmkIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LoadTestingCmkIdentityType"/> values are not the same. </summary>
        public static bool operator !=(LoadTestingCmkIdentityType left, LoadTestingCmkIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LoadTestingCmkIdentityType"/>. </summary>
        public static implicit operator LoadTestingCmkIdentityType(string value) => new LoadTestingCmkIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LoadTestingCmkIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LoadTestingCmkIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
