// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.LoadTesting.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.LoadTesting
{
    /// <summary>
    /// A class representing the LoadTestingQuota data model.
    /// Quota bucket details object.
    /// </summary>
    public partial class LoadTestingQuotaData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LoadTestingQuotaData"/>. </summary>
        public LoadTestingQuotaData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LoadTestingQuotaData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="limit"> Current quota limit of the quota bucket. </param>
        /// <param name="usage"> Current quota usage of the quota bucket. </param>
        /// <param name="provisioningState"> Resource provisioning state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LoadTestingQuotaData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, int? limit, int? usage, LoadTestingProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Limit = limit;
            Usage = usage;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Current quota limit of the quota bucket. </summary>
        public int? Limit { get; set; }
        /// <summary> Current quota usage of the quota bucket. </summary>
        public int? Usage { get; set; }
        /// <summary> Resource provisioning state. </summary>
        public LoadTestingProvisioningState? ProvisioningState { get; }
    }
}
