// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.LoadTesting.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableLoadTestingResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableLoadTestingResourceGroupResource"/> class for mocking. </summary>
        protected MockableLoadTestingResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableLoadTestingResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableLoadTestingResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of LoadTestingResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of LoadTestingResources and their operations over a LoadTestingResource. </returns>
        public virtual LoadTestingResourceCollection GetLoadTestingResources()
        {
            return GetCachedClient(client => new LoadTestingResourceCollection(client, Id));
        }

        /// <summary>
        /// Get a LoadTest resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LoadTestingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadTestName"> Load Test name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="loadTestName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="loadTestName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<LoadTestingResource>> GetLoadTestingResourceAsync(string loadTestName, CancellationToken cancellationToken = default)
        {
            return await GetLoadTestingResources().GetAsync(loadTestName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a LoadTest resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.LoadTestService/loadTests/{loadTestName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>LoadTests_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="LoadTestingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="loadTestName"> Load Test name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="loadTestName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="loadTestName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<LoadTestingResource> GetLoadTestingResource(string loadTestName, CancellationToken cancellationToken = default)
        {
            return GetLoadTestingResources().Get(loadTestName, cancellationToken);
        }
    }
}
