// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Developer.LoadTesting
{
    /// <summary> Client options for AzureLoadTesting library clients. </summary>
    public partial class LoadTestingClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2022_11_01;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2022-11-01". </summary>
            V2022_11_01 = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of LoadTestingClientOptions. </summary>
        public LoadTestingClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2022_11_01 => "2022-11-01",
                _ => throw new NotSupportedException()
            };
        }
    }
}
