// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabVirtualMachineStateExtensions
    {
        public static string ToSerialString(this LabVirtualMachineState value) => value switch
        {
            LabVirtualMachineState.Stopped => "Stopped",
            LabVirtualMachineState.Starting => "Starting",
            LabVirtualMachineState.Running => "Running",
            LabVirtualMachineState.Stopping => "Stopping",
            LabVirtualMachineState.ResettingPassword => "ResettingPassword",
            LabVirtualMachineState.Reimaging => "Reimaging",
            LabVirtualMachineState.Redeploying => "Redeploying",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineState value.")
        };

        public static LabVirtualMachineState ToLabVirtualMachineState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Stopped")) return LabVirtualMachineState.Stopped;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Starting")) return LabVirtualMachineState.Starting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Running")) return LabVirtualMachineState.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Stopping")) return LabVirtualMachineState.Stopping;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "ResettingPassword")) return LabVirtualMachineState.ResettingPassword;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Reimaging")) return LabVirtualMachineState.Reimaging;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Redeploying")) return LabVirtualMachineState.Redeploying;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineState value.");
        }
    }
}
