// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabVirtualMachineShutdownOnIdleModeExtensions
    {
        public static string ToSerialString(this LabVirtualMachineShutdownOnIdleMode value) => value switch
        {
            LabVirtualMachineShutdownOnIdleMode.None => "None",
            LabVirtualMachineShutdownOnIdleMode.UserAbsence => "UserAbsence",
            LabVirtualMachineShutdownOnIdleMode.LowUsage => "LowUsage",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineShutdownOnIdleMode value.")
        };

        public static LabVirtualMachineShutdownOnIdleMode ToLabVirtualMachineShutdownOnIdleMode(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return LabVirtualMachineShutdownOnIdleMode.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "UserAbsence")) return LabVirtualMachineShutdownOnIdleMode.UserAbsence;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "LowUsage")) return LabVirtualMachineShutdownOnIdleMode.LowUsage;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineShutdownOnIdleMode value.");
        }
    }
}
