// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabVirtualMachineImageOSTypeExtensions
    {
        public static string ToSerialString(this LabVirtualMachineImageOSType value) => value switch
        {
            LabVirtualMachineImageOSType.Windows => "Windows",
            LabVirtualMachineImageOSType.Linux => "Linux",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineImageOSType value.")
        };

        public static LabVirtualMachineImageOSType ToLabVirtualMachineImageOSType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Windows")) return LabVirtualMachineImageOSType.Windows;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Linux")) return LabVirtualMachineImageOSType.Linux;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineImageOSType value.");
        }
    }
}
