// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabVirtualMachineImageOSStateExtensions
    {
        public static string ToSerialString(this LabVirtualMachineImageOSState value) => value switch
        {
            LabVirtualMachineImageOSState.Generalized => "Generalized",
            LabVirtualMachineImageOSState.Specialized => "Specialized",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineImageOSState value.")
        };

        public static LabVirtualMachineImageOSState ToLabVirtualMachineImageOSState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Generalized")) return LabVirtualMachineImageOSState.Generalized;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Specialized")) return LabVirtualMachineImageOSState.Specialized;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineImageOSState value.");
        }
    }
}
