// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> Credentials for a user on a lab VM. </summary>
    public partial class LabVirtualMachineCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabVirtualMachineCredential"/>. </summary>
        /// <param name="username"> The username to use when signing in to lab VMs. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="username"/> is null. </exception>
        public LabVirtualMachineCredential(string username)
        {
            Argument.AssertNotNull(username, nameof(username));

            Username = username;
        }

        /// <summary> Initializes a new instance of <see cref="LabVirtualMachineCredential"/>. </summary>
        /// <param name="username"> The username to use when signing in to lab VMs. </param>
        /// <param name="password"> The password for the user. This is required for the TemplateVM createOption. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabVirtualMachineCredential(string username, string password, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            Password = password;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LabVirtualMachineCredential"/> for deserialization. </summary>
        internal LabVirtualMachineCredential()
        {
        }

        /// <summary> The username to use when signing in to lab VMs. </summary>
        public string Username { get; set; }
        /// <summary> The password for the user. This is required for the TemplateVM createOption. </summary>
        public string Password { get; set; }
    }
}
