// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabVirtualMachineCreateOptionExtensions
    {
        public static string ToSerialString(this LabVirtualMachineCreateOption value) => value switch
        {
            LabVirtualMachineCreateOption.Image => "Image",
            LabVirtualMachineCreateOption.TemplateVm => "TemplateVM",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineCreateOption value.")
        };

        public static LabVirtualMachineCreateOption ToLabVirtualMachineCreateOption(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Image")) return LabVirtualMachineCreateOption.Image;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TemplateVM")) return LabVirtualMachineCreateOption.TemplateVm;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabVirtualMachineCreateOption value.");
        }
    }
}
