// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabUserRegistrationStateExtensions
    {
        public static string ToSerialString(this LabUserRegistrationState value) => value switch
        {
            LabUserRegistrationState.Registered => "Registered",
            LabUserRegistrationState.NotRegistered => "NotRegistered",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabUserRegistrationState value.")
        };

        public static LabUserRegistrationState ToLabUserRegistrationState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Registered")) return LabUserRegistrationState.Registered;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NotRegistered")) return LabUserRegistrationState.NotRegistered;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabUserRegistrationState value.");
        }
    }
}
