// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabStateExtensions
    {
        public static string ToSerialString(this LabState value) => value switch
        {
            LabState.Draft => "Draft",
            LabState.Publishing => "Publishing",
            LabState.Scaling => "Scaling",
            LabState.Syncing => "Syncing",
            LabState.Published => "Published",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabState value.")
        };

        public static LabState ToLabState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Draft")) return LabState.Draft;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Publishing")) return LabState.Publishing;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Scaling")) return LabState.Scaling;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Syncing")) return LabState.Syncing;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Published")) return LabState.Published;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabState value.");
        }
    }
}
