// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The unit details. </summary>
    public readonly partial struct LabServicesUsageUnit : IEquatable<LabServicesUsageUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LabServicesUsageUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LabServicesUsageUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "Count";

        /// <summary> Count. </summary>
        public static LabServicesUsageUnit Count { get; } = new LabServicesUsageUnit(CountValue);
        /// <summary> Determines if two <see cref="LabServicesUsageUnit"/> values are the same. </summary>
        public static bool operator ==(LabServicesUsageUnit left, LabServicesUsageUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LabServicesUsageUnit"/> values are not the same. </summary>
        public static bool operator !=(LabServicesUsageUnit left, LabServicesUsageUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LabServicesUsageUnit"/>. </summary>
        public static implicit operator LabServicesUsageUnit(string value) => new LabServicesUsageUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LabServicesUsageUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LabServicesUsageUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
