// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The core usage details. </summary>
    public partial class LabServicesUsage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LabServicesUsage"/>. </summary>
        internal LabServicesUsage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LabServicesUsage"/>. </summary>
        /// <param name="currentValue"> The current usage. </param>
        /// <param name="limit"> The limit integer. </param>
        /// <param name="unit"> The unit details. </param>
        /// <param name="name"> The name. </param>
        /// <param name="id"> The fully qualified arm resource id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LabServicesUsage(long? currentValue, long? limit, LabServicesUsageUnit? unit, LabServicesUsageName name, ResourceIdentifier id, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CurrentValue = currentValue;
            Limit = limit;
            Unit = unit;
            Name = name;
            Id = id;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The current usage. </summary>
        public long? CurrentValue { get; }
        /// <summary> The limit integer. </summary>
        public long? Limit { get; }
        /// <summary> The unit details. </summary>
        public LabServicesUsageUnit? Unit { get; }
        /// <summary> The name. </summary>
        public LabServicesUsageName Name { get; }
        /// <summary> The fully qualified arm resource id. </summary>
        public ResourceIdentifier Id { get; }
    }
}
