// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.LabServices.Models
{
    internal static partial class LabServicesSkuTierExtensions
    {
        public static string ToSerialString(this LabServicesSkuTier value) => value switch
        {
            LabServicesSkuTier.Free => "Free",
            LabServicesSkuTier.Basic => "Basic",
            LabServicesSkuTier.Standard => "Standard",
            LabServicesSkuTier.Premium => "Premium",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabServicesSkuTier value.")
        };

        public static LabServicesSkuTier ToLabServicesSkuTier(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Free")) return LabServicesSkuTier.Free;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Basic")) return LabServicesSkuTier.Basic;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Standard")) return LabServicesSkuTier.Standard;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Premium")) return LabServicesSkuTier.Premium;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown LabServicesSkuTier value.");
        }
    }
}
