// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.LabServices.Models
{
    /// <summary> The type of restriction. </summary>
    public readonly partial struct LabServicesSkuRestrictionType : IEquatable<LabServicesSkuRestrictionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LabServicesSkuRestrictionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LabServicesSkuRestrictionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocationValue = "Location";

        /// <summary> Location. </summary>
        public static LabServicesSkuRestrictionType Location { get; } = new LabServicesSkuRestrictionType(LocationValue);
        /// <summary> Determines if two <see cref="LabServicesSkuRestrictionType"/> values are the same. </summary>
        public static bool operator ==(LabServicesSkuRestrictionType left, LabServicesSkuRestrictionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LabServicesSkuRestrictionType"/> values are not the same. </summary>
        public static bool operator !=(LabServicesSkuRestrictionType left, LabServicesSkuRestrictionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LabServicesSkuRestrictionType"/>. </summary>
        public static implicit operator LabServicesSkuRestrictionType(string value) => new LabServicesSkuRestrictionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LabServicesSkuRestrictionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LabServicesSkuRestrictionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
